/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.triggers.api.form.EventBasedTriggerTestRunForm;
import com.xebialabs.xlrelease.triggers.api.view.EventBasedTriggerTestRunResult;
import com.xebialabs.xlrelease.triggers.security.TriggerPermissionChecker;
import com.xebialabs.xlrelease.triggers.service.EventTriggerTestRunService;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.utils.SortSupport;
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/triggers")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TriggersApi
implements ApiService {
    private final TriggerPermissionChecker triggerPermissionChecker;
    private final TriggerService triggerService;
    private final EventTriggerTestRunService eventTriggerTestRunService;

    @Autowired
    public TriggersApi(TriggerPermissionChecker triggerPermissionChecker, TriggerService triggerService, EventTriggerTestRunService eventTriggerTestRunService) {
        this.triggerPermissionChecker = triggerPermissionChecker;
        this.triggerService = triggerService;
        this.eventTriggerTestRunService = eventTriggerTestRunService;
    }

    public String serviceName() {
        return "triggersApi";
    }

    @GET
    @Timed
    public Page<ReleaseTriggerOverview> searchTriggers(@BeanParam TriggerFilters triggerFilters, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, @Context UriInfo uriInfo) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)SortSupport.toSort((UriInfo)uriInfo));
        return this.searchTriggers(triggerFilters, (Pageable)pageable);
    }

    @PublicApiMember
    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage, Sort sort) {
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)sort);
        return this.searchTriggers(triggerFilters, (Pageable)pageable).getContent();
    }

    @PublicApiMember
    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage) {
        return this.searchTriggers(triggerFilters, page, resultsPerPage, Sort.unsorted());
    }

    @Timed
    public Page<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, Pageable pageable) {
        if (triggerFilters == null) {
            triggerFilters = new TriggerFilters();
        }
        return this.triggerService.findBy(triggerFilters, pageable);
    }

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/enable")
    @PublicApiMember
    @Timed
    public void enableTrigger(@PathParam(value="triggerId") String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.updateTriggerStatus(triggerId, true);
    }

    @POST
    @Path(value="enable")
    @PublicApiMember
    @Timed
    public BulkActionResultView enableTriggers(List<String> triggerIds) {
        List<String> allowedTriggers = this.triggerPermissionChecker.filterEditableTriggers(triggerIds);
        List<String> enabledTriggers = this.triggerService.enableTriggers(allowedTriggers);
        return new BulkActionResultView(enabledTriggers);
    }

    @POST
    @Path(value="enable/all")
    @PublicApiMember
    @Timed
    public BulkActionResultView enableAllTriggers() {
        List<String> enabledTriggers = this.triggerService.enableAllAccessibleTriggers();
        return new BulkActionResultView(enabledTriggers);
    }

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/disable")
    @PublicApiMember
    @Timed
    public void disableTrigger(@PathParam(value="triggerId") String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.updateTriggerStatus(triggerId, false);
    }

    @POST
    @Path(value="disable")
    @PublicApiMember
    @Timed
    public BulkActionResultView disableTriggers(List<String> triggerIds) {
        List<String> allowedTriggers = this.triggerPermissionChecker.filterEditableTriggers(triggerIds);
        List<String> disabledTriggers = this.triggerService.disableTriggers(allowedTriggers);
        return new BulkActionResultView(disabledTriggers);
    }

    @POST
    @Path(value="disable/all")
    @PublicApiMember
    @Timed
    public BulkActionResultView disableAllTriggers() {
        List<String> disabledTriggers = this.triggerService.disableAllAccessibleTriggers();
        return new BulkActionResultView(disabledTriggers);
    }

    @DELETE
    @Path(value="{triggerId:.*/Trigger[^/]*}")
    @PublicApiMember
    @Timed
    public void removeTrigger(@PathParam(value="triggerId") String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.deleteTrigger(triggerId);
    }

    @POST
    @Path(value="{triggerId:.*/Trigger[^/]*}/run")
    @Timed
    public void runTrigger(@PathParam(value="triggerId") String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.runNowTrigger(triggerId);
    }

    @POST
    @Path(value="event-based/test-run")
    @Timed
    public EventBasedTriggerTestRunResult testRunTrigger(EventBasedTriggerTestRunForm form) {
        HttpRequestEvent event = new HttpRequestEvent();
        event.setId("TestRunEventId");
        event.setSourceId("TestRunSourceId");
        event.setReceived(new Date());
        event.setHeaders(form.event().getHeaders());
        event.setParameters(form.event().getParameters());
        event.setContent(form.event().getContent());
        return this.eventTriggerTestRunService.testRun(form.trigger(), event);
    }

    @GET
    @Timed
    @PublicApiMember
    @Path(value="types")
    public List<Descriptor> getTypes() {
        return DescriptorRegistry.getSubtypes((Type)Type.valueOf(Trigger.class)).stream().map(Type::getDescriptor).filter(desc -> !desc.isVirtual() && !desc.getType().equals((Object)Type.valueOf(ReleaseTrigger.class))).collect(Collectors.toList());
    }

    @POST
    @Timed
    @PublicApiMember
    public Trigger addTrigger(Trigger trigger) {
        this.triggerPermissionChecker.checkEditTrigger(trigger);
        return this.triggerService.addTrigger(trigger);
    }

    @GET
    @Timed
    @PublicApiMember
    @Path(value="{triggerId:.*Trigger[^/-]*}")
    public Trigger getTrigger(@PathParam(value="triggerId") String triggerId) {
        Trigger trigger = this.triggerService.findById(triggerId);
        this.triggerPermissionChecker.checkViewTrigger(trigger);
        return trigger;
    }

    @PUT
    @Timed
    @PublicApiMember
    @Path(value="{triggerId:.*Trigger[^/-]*}")
    public Trigger updateTrigger(@PathParam(value="triggerId") String triggerId, Trigger trigger) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        trigger.setId(triggerId);
        return this.triggerService.updateTrigger(trigger);
    }
}

