import React, { useState } from 'react';
import { ExternalDeploymentsTable } from './external-deployments-table.component';
import { FolderExternalDeploymentsProps } from './folder-external-deployments';
import { BasicDiscovery } from './wizard/basic-wizard/application-discovery-basic.component';

export const FolderExternalDeploymentsWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const [isWizardView, setIsWizardView] = useState<boolean>(false);

    return (
        <>
            {isWizardView ? (
                <BasicDiscovery closeWizard={() => setIsWizardView(false)} folder={folder} />
            ) : (
                <ExternalDeploymentsTable folder={folder} onViewChange={() => setIsWizardView(true)} />
            )}
        </>
    );
};
