import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { folderExternalDeployments, FolderExternalDeploymentsState, initialState } from '../../ducks/external-deployments.reducer';
import { ApplicationsDiscovery } from './applications-discovery-component';

const { loadServers, loadWebhookSources, setPreSelectedServer } = folderExternalDeployments.actions;
const dispatch = jest.fn();
describe('Application discovery component', () => {
    let wrapper: ReactWrapper;
    const onCancel = jest.fn();
    const onSave = jest.fn();
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder-1' },
        onCancel,
        onSave,
    };
    const defaultState = {
        ...initialState,
    };

    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<ApplicationsDiscovery {...defaultProps} />, dispatch, { folderExternalDeployments: state });
    };

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should dispatch actions ', () => {
        expect(dispatch.mock.calls.length).toEqual(3);
        expect(dispatch).toBeCalledWith(loadServers('folderId'));
        expect(dispatch).toBeCalledWith(loadWebhookSources('folderId'));
        expect(dispatch).toBeCalledWith(setPreSelectedServer(undefined));
    });
});
