import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { EventChannel } from 'redux-saga';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import {
    ConnectionServer,
    CreateStatusEvent,
    DeleteStatusEvent,
    EndpointExternalDeploymentEvent,
    WebhookEndpoint,
    ExternalDeployment,
    SaveWebhookSourceFiltersRequest,
    Server,
    SetupLiveUpdateRequest,
    ExternalDeploymentPage,
    UpdateStatusEvent,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
} from '../external-deployment.types';

import { DEFAULT_MAX_AGE, DEFAULT_ORDER, DEFAULT_ORDER_BY, DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE, DEFAULT_CONDITION } from '../constants';

export interface FolderExternalDeploymentsState {
    condition: string;
    configDetails?: WebhookSourceAutoConfigDetails;
    connectionErrors: Array<string>;
    connectionServers: Map<string, ConnectionServer>;
    count: number;
    disconnectedServers: Array<string>;
    externalDeploymentChannel?: EventChannel<Event>;
    externalDeployments: Array<ExternalDeployment>;
    filterEventSource?: WebhookEndpoint;
    folderId?: string;
    isLoading: boolean;
    maxAge: number;
    page: ExternalDeploymentPage;
    servers: Array<Server>;
    webhookSourceFilters?: WebhookSourceFilter;
    webhookSources: Array<WebhookSource>;
}

const initialPage: ExternalDeploymentPage = {
    folderId: undefined,
    order: DEFAULT_ORDER,
    orderBy: DEFAULT_ORDER_BY,
    page: DEFAULT_PAGE,
    resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
};

export const initialState: FolderExternalDeploymentsState = {
    count: 0,
    connectionServers: new Map<string, ConnectionServer>(),
    connectionErrors: [],
    configDetails: undefined,
    disconnectedServers: [],
    externalDeploymentChannel: undefined,
    externalDeployments: [],
    filterEventSource: undefined,
    folderId: undefined,
    isLoading: false,
    maxAge: DEFAULT_MAX_AGE,
    servers: [],
    webhookSources: [],
    webhookSourceFilters: undefined,
    condition: DEFAULT_CONDITION,
    page: initialPage,
};

export const folderExternalDeployments = createSlice({
    name: 'folderExternalDeployments',
    initialState,
    reducers: {
        createApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<CreateStatusEvent>>) => noop(),
        createServer: (_state: FolderExternalDeploymentsState, _action: PayloadAction<Server>) => noop(),
        deleteApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<DeleteStatusEvent>>) => noop(),
        loadExternalDeployments: (_state: FolderExternalDeploymentsState) => noop(),
        refreshExternalDeployments: (_state: FolderExternalDeploymentsState) => noop(),
        loadWebhookSources: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        loadWebhookSourceFilters: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        loadServers: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        setConnectionServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Map<string, ConnectionServer>>) => {
            state.connectionServers = action.payload;
        },
        setConnectionErrors: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<string>>) => {
            state.connectionErrors = action.payload;
        },
        setConfigDetails: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookSourceAutoConfigDetails | undefined>) => {
            state.configDetails = action.payload;
        },
        setServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<Server>>) => {
            state.servers = action.payload;
        },
        setExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<ExternalDeployment>>) => {
            state.externalDeployments = action.payload;
        },
        setExternalDeploymentsCount: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.count = action.payload;
        },
        setIsLoading: (state: FolderExternalDeploymentsState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setMaxAge: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.maxAge = action.payload;
        },
        setSseStreamChannel: (state: FolderExternalDeploymentsState, action: PayloadAction<EventChannel<Event> | undefined>) => {
            state.externalDeploymentChannel = action.payload;
        },
        addServerToServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Server>) => {
            state.servers = [...state.servers, action.payload];
        },
        setLiveUpdate: (_state: FolderExternalDeploymentsState, _action: PayloadAction<SetupLiveUpdateRequest>) => noop(),
        setWebhookSources: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<WebhookSource>>) => {
            state.webhookSources = action.payload;
        },
        setWebhookSourceFilters: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookSourceFilter>) => {
            state.webhookSourceFilters = action.payload;
        },
        subscribeToSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        updateApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<UpdateStatusEvent>>) => noop(),
        unsubscribeFromSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        updateWebhookSourceFilters: (_state: FolderExternalDeploymentsState, _action: PayloadAction<SaveWebhookSourceFiltersRequest>) => noop(),
        deleteWebhookSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        removeWebhookSource: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.webhookSources = state.webhookSources.filter((webhookSource) => webhookSource.id !== action.payload);
        },
        loadFilterEventSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        setFilterEventSource: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookEndpoint>) => {
            state.filterEventSource = action.payload;
        },
        saveEventSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<WebhookEndpoint>) => noop(),
        setCondition: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.condition = action.payload;
        },
        setPage: (state: FolderExternalDeploymentsState, action: PayloadAction<ExternalDeploymentPage>) => {
            state.page = action.payload;
        },
        storeFilters: (_state: FolderExternalDeploymentsState) => noop(),
        getFilters: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.page.folderId = action.payload;
        },
        patchExternalDeployments: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        setDisconnectedServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<string>>) => {
            state.disconnectedServers = action.payload;
        },
        updateBreadcrumbs: (_state: FolderExternalDeploymentsState, _action: PayloadAction<Folder>) => noop(),
    },
});
