import React, { useState } from 'react';
import { DotDialog, DotThemeProvider, DotTypography } from '@digital-ai/dot-components';
import './patch-modal-component.less';

export interface PatchModalProps {
    isModalOpen: boolean;
    onModalUpdateAutomatically: () => void;
    onModalUpdateManually: () => void;
}

export const PatchModal = (props: PatchModalProps) => {
    const { isModalOpen, onModalUpdateManually, onModalUpdateAutomatically } = props;
    const [isDetailCollapsed, setIsDetailCollapsed] = useState<boolean>(true);

    const resolveDetailCollapseText = () => {
        if (isDetailCollapsed) return 'Learn more..';
        else return 'Collapse';
    };

    return (
        <DotThemeProvider>
            <DotDialog
                cancelButtonProps={{ label: 'Update Manually' }}
                className="patch-dialog"
                onCancel={onModalUpdateManually}
                onSubmit={onModalUpdateAutomatically}
                open={isModalOpen}
                submitButtonProps={{ label: 'Update Automatically' }}
                title={'Patch available'}
            >
                <div className="patch-dialog-body">
                    <DotTypography variant="body1">
                        ArgoCD applications need to subscribe to Release notification webhooks if you wish to receive live updates from ArgoCD.
                    </DotTypography>
                    <br />
                    <DotTypography variant="body1">You can choose to update it manually or automatically. How would you like to proceed?</DotTypography>
                    <br />
                    {!isDetailCollapsed && (
                        <div className="patch-details">
                            <DotTypography variant="body1">ArgoCD Application.yaml files will be patched with following annotations:</DotTypography>
                            <br />
                            <div className="patch-details-header">
                                <DotTypography variant="h4">Annotations</DotTypography>
                            </div>
                            <div className="patch-details-body">
                                <DotTypography variant="body1">
                                    notifications.argoproj.io/subscribe.on-created.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-deleted.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-unknown.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-progressing.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-suspended.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-healthy.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-degraded.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-health-missing.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-sync-unknown.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-sync-synced.release-webhook: &quot;&quot;
                                    notifications.argoproj.io/subscribe.on-sync-out-of-sync.release-webhook: &quot;&quot;
                                </DotTypography>
                            </div>
                        </div>
                    )}
                    <div className="patch-details-collapse">
                        <p onClick={() => setIsDetailCollapsed(!isDetailCollapsed)}>{resolveDetailCollapseText()}</p>
                    </div>
                </div>
            </DotDialog>
        </DotThemeProvider>
    );
};
