import React, { memo } from 'react';
import './application-wizard-setup-component.less';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';
import { ApplicationsDiscovery } from './applications-discovery-component';

export interface FolderApplicationsWizardSetupProps {
    folder: Folder;
    onViewChange: () => void;
}

const WizardSetupComponent = (props: FolderApplicationsWizardSetupProps) => {
    const { folder, onViewChange } = props;

    const closeWizard = () => {
        onViewChange();
    };

    return <ApplicationsDiscovery folder={folder} onCancel={closeWizard} onSave={onViewChange} />;
};

export const WizardSetup = memo(WizardSetupComponent);
