import React from 'react';
import { useState, useEffect } from 'react';
import { ExternalDeploymentsTable } from './external-deployments-table.component';
import { WizardSetup } from './wizard/application-wizard-setup-component';
import { FolderExternalDeploymentsProps } from './folder-external-deployments';

export const FolderExternalDeploymentsWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const [isWizardView, setIsWizardView] = useState<boolean>(false);

    const closeWizard = () => {
        setIsWizardView(false);
    };

    return (
        <>
            {!isWizardView ? (
                <ExternalDeploymentsTable folder={folder} onViewChange={() => setIsWizardView(true)} />
            ) : (
                <WizardSetup folder={folder} onViewChange={closeWizard} />
            )}
        </>
    );
};
