package com.xebialabs.xlrelease.status.service.script

import com.xebialabs.xlrelease.domain.ScriptHelper
import com.xebialabs.xlrelease.script.builder.{ScriptContextBuilder, _}
import com.xebialabs.xlrelease.script.{EncryptionHelper, XlrScript, XlrScriptContext}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource

private abstract class BaseScriptContextBuilder(connection: StatusWebhookEventSource) extends ScriptContextBuilder {
  val scriptProperty: String

  val sourceServer: StatusHttpConnection = connection.sourceServer

  final val StatusScriptProperty = "statusScript"
  final val AutoconfigScriptProperty = "autoconfigScript"
  final val FiltersRequestScriptProperty = "filtersRequest"

  withLogger().withScriptApi()
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  protected def addConnectionServerAttributes(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(sourceServer)
    context.addCiAsMap("connectionServer", sourceServer)
  }

  protected def addConnectionAttributes(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(connection)
    context.addCiAsMap("connection", connection)
  }

  protected def addScript(context: XlrScriptContext): Unit = {
    val script = ScriptHelper.getScript(scriptProperty, connection, s".$scriptProperty")
    val name = s"${connection.getType}[${connection.getTitle}-$scriptProperty]"
    context.addScript(XlrScript.byContent(name = name, content = script, wrap = false, checkPermissions = false))
  }
}
