package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.internal.views.{
  ExternalDeploymentOrderDirection,
  ExternalDeploymentOrderMode,
  ExternalDeploymentView,
  WebhookBasicSetupView,
  WebhookSourceFiltersView
}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.status.service.{EndpointExternalDeploymentService, EndpointSetupDeploymentStatusService}
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import org.springframework.stereotype.Controller

import java.{lang, util}
import scala.jdk.CollectionConverters._

@Controller
class ExternalDeploymentApiImpl(
                                externalDeploymentService: EndpointExternalDeploymentService,
                                setupDeploymentStatusService: EndpointSetupDeploymentStatusService,
                                configurationRepository: ConfigurationRepository
                              ) extends  ExternalDeploymentApi {
  override def getExternalDeployments(
                                       folderId: String,
                                       maxAge: lang.Long,
                                       page: lang.Long,
                                       resultsPerPage: lang.Long,
                                       orderBy: ExternalDeploymentOrderMode,
                                       direction: ExternalDeploymentOrderDirection,
                                       condition: String
                                     ): ExternalDeploymentView = {
    val endpointIds = configurationRepository
      .findAllByTypeAndTitle[StatusWebhookEventSource](Type.valueOf(classOf[StatusWebhookEventSource]), null, folderId, folderOnly = true)
      .asScala.map(_.getId).toVector
    externalDeploymentService.getExternalDeployment(endpointIds, maxAge, page, resultsPerPage, orderBy, direction, condition)
  }
  override def getWebhookSourceFilters(webhookSourceId: String): WebhookSourceFiltersView =
    externalDeploymentService.getWebhookSourceFilters(webhookSourceId)

  override def setupApplicationStatusWebhook(serverId: String, folderId: String): WebhookBasicSetupView =
    setupDeploymentStatusService.setupApplicationStatusWebhook(serverId, folderId)

  override def saveWebhookSourceFilters(webhookSourceId: String, filteredFolders: util.List[String]): StatusWebhookEventSource =
    externalDeploymentService.saveWebhookSourceFilters(webhookSourceId, filteredFolders.asScala.toList)
}
