package com.xebialabs.xlrelease.api.internal;

import java.util.List;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.internal.views.*;
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("/external-deployment")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface ExternalDeploymentApi extends ApiService {

    default String serviceName() {
        return "externalDeploymentApi";
    }

    @GET
    ExternalDeploymentView getExternalDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam("max-age") Long maxAge,
            @DefaultValue("0") @QueryParam(PAGE) Long page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
            @DefaultValue("STATUS") @QueryParam(ORDER_BY) ExternalDeploymentOrderMode orderBy,
            @DefaultValue("ASC") @QueryParam("order") ExternalDeploymentOrderDirection direction,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    @GET
    @Path("/filters/{webhookSourceId:.*/Configuration[^/]*}")
    WebhookSourceFiltersView getWebhookSourceFilters(
            @PathParam("webhookSourceId") String webhookSourceId
    );

    @PUT
    @Path("/filters/{webhookSourceId:.*/Configuration[^/]*}")
    StatusWebhookEventSource saveWebhookSourceFilters(
            @PathParam("webhookSourceId") String webhookSourceId,
            List<String> filteredFolders);

    @POST
    @Path("/setup/{serverId:.*/Configuration[^/]*}")
    WebhookBasicSetupView setupApplicationStatusWebhook(
            @PathParam("serverId") String serverId,
            @QueryParam("folderId") String folderId
    );
}
