// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { EventSource } from 'mocksse';
import { getDeepLink, getServerIcon, getVersionLabel, mapOrderByValue, registerEventSource, subscribeToSse, trimCommitHash } from './utils';
import {
    APPLICATION_COLUMN_ID,
    APPLICATION_ORDER_BY,
    DESTINATION_COLUMN_ID,
    DESTINATION_ORDER_BY,
    ENDPOINT_TYPE,
    IMG_SRC,
    SSE_REGISTRATION_URL,
    STATUS_COLUMN_ID,
    STATUS_ORDER_BY,
    TIME_COLUMN_ID,
    TIME_ORDER_BY,
    VERSION_COLUMN_ID,
    VERSION_ORDER_BY,
} from '../constants';

describe('utils', () => {
    beforeAll(() => {
        global.EventSource = EventSource;
    });

    describe('registerEventSource', () => {
        it('should create new EventSource from url', () => {
            expect(registerEventSource(SSE_REGISTRATION_URL)).toMatchObject({
                _eventsCount: 0,
                CLOSED: 2,
                CONNECTING: 0,
                OPEN: 1,
                readyState: null,
                responses: [],
                url: SSE_REGISTRATION_URL,
            });
        });
    });

    describe('subscribeToSse', () => {
        it('should add event listeners for 5 events', () => {
            const eventSrc = registerEventSource(SSE_REGISTRATION_URL);
            const result = subscribeToSse(eventSrc);
            expect(result).toMatchObject({
                close: expect.any(Function),
                flush: expect.any(Function),
                take: expect.any(Function),
            });
        });
    });

    describe('getDeepLink', () => {
        it('should combine endpointUrl with applicationPath', () => {
            expect(getDeepLink('endp', 'oint')).toStrictEqual('endpoint');
        });
    });

    describe('getServerIcon', () => {
        it('should give icon for type, default is empty', () => {
            expect(getServerIcon(ENDPOINT_TYPE.deploy)).toStrictEqual(IMG_SRC.deploy);
            expect(getServerIcon(ENDPOINT_TYPE.argoCd)).toStrictEqual(IMG_SRC.argoCd);
            expect(getServerIcon('')).toStrictEqual('');
        });
    });

    describe('mapOrderByValue', () => {
        it('should map columnName to correct orderBy value', () => {
            expect(mapOrderByValue(APPLICATION_COLUMN_ID)).toStrictEqual(APPLICATION_ORDER_BY);
            expect(mapOrderByValue(DESTINATION_COLUMN_ID)).toStrictEqual(DESTINATION_ORDER_BY);
            expect(mapOrderByValue(STATUS_COLUMN_ID)).toStrictEqual(STATUS_ORDER_BY);
            expect(mapOrderByValue(VERSION_COLUMN_ID)).toStrictEqual(VERSION_ORDER_BY);
            expect(mapOrderByValue(TIME_COLUMN_ID)).toStrictEqual(TIME_ORDER_BY);
        });
        it('should map unknown columnName to default orderBy of STATE', () => {
            expect(mapOrderByValue('other')).toStrictEqual(STATUS_ORDER_BY);
        });
    });

    describe('trimCommitHash', () => {
        it('should trim commit hash if its length exceeds 6', () => {
            expect(trimCommitHash('#d654f0c68f9213b19818ba23d91350886362431a')).toStrictEqual('#d654f0');
        });
        it('should return commit hash if its length is less than 6', () => {
            expect(trimCommitHash('#d654')).toStrictEqual('#d654');
        });
    });

    describe('getVersionLabel', () => {
        it('should trim ArgoCD version label', () => {
            expect(getVersionLabel(ENDPOINT_TYPE.argoCd, '#d654f0c68f9213b19818ba23d91350886362431a')).toStrictEqual('#d654f0');
        });
        it('should not trim Deploy version label', () => {
            expect(getVersionLabel(ENDPOINT_TYPE.deploy, '1.0')).toStrictEqual('1.0');
        });
    });
});
