import { EventChannel } from 'redux-saga';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { FolderExternalDeploymentsState } from './external-deployments.reducer';
import { ConnectionServer, ExternalDeployment, ExternalDeploymentPage } from '../external-deployment.types';

export const getFolderExternalDeployments = (state: RootState): FolderExternalDeploymentsState => state.folderExternalDeployments;
export const getApplicationStatusChannelSelector = (state: RootState): EventChannel<Event> | undefined =>
    getFolderExternalDeployments(state).externalDeploymentChannel;
export const getConnectionServersSelector = (state: RootState): Map<string, ConnectionServer> => getFolderExternalDeployments(state).connectionServers;
export const getExternalDeploymentsSelector = (state: RootState): Array<ExternalDeployment> => getFolderExternalDeployments(state).externalDeployments;
export const getExternalDeploymentPageSelector = (state: RootState): ExternalDeploymentPage => getFolderExternalDeployments(state).page;
export const getExternalDeploymentCountSelector = (state: RootState): number => getFolderExternalDeployments(state).count;
export const getIsLoadingSelector = (state: RootState): boolean => getFolderExternalDeployments(state).isLoading;
export const getConditionSelector = (state: RootState): string => getFolderExternalDeployments(state).condition;
