import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { EventChannel } from 'redux-saga';
import {
    ConnectionServer,
    CreateStatusEvent,
    DeleteStatusEvent,
    EndpointExternalDeploymentEvent,
    ExternalDeployment,
    ExternalDeploymentPage,
    UpdateStatusEvent,
} from '../external-deployment.types';

import { DEFAULT_MAX_AGE, DEFAULT_ORDER, DEFAULT_ORDER_BY, DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE, DEFAULT_CONDITION } from '../constants';

export interface FolderExternalDeploymentsState {
    condition: string;
    connectionServers: Map<string, ConnectionServer>;
    count: number;
    externalDeploymentChannel?: EventChannel<Event>;
    externalDeployments: Array<ExternalDeployment>;
    isLoading: boolean;
    maxAge: number;
    page: ExternalDeploymentPage;
}

const initialPage: ExternalDeploymentPage = {
    folderId: undefined,
    order: DEFAULT_ORDER,
    orderBy: DEFAULT_ORDER_BY,
    page: DEFAULT_PAGE,
    resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
};

export const initialState: FolderExternalDeploymentsState = {
    count: 0,
    connectionServers: new Map<string, ConnectionServer>(),
    externalDeploymentChannel: undefined,
    externalDeployments: [],
    isLoading: false,
    maxAge: DEFAULT_MAX_AGE,
    condition: DEFAULT_CONDITION,
    page: initialPage,
};

export const folderExternalDeployments = createSlice({
    name: 'folderExternalDeployments',
    initialState,
    reducers: {
        createApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<CreateStatusEvent>>) => noop(),
        deleteApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<DeleteStatusEvent>>) => noop(),
        loadExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<ExternalDeploymentPage>) => {
            state.page = action.payload;
        },
        setConnectionServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Map<string, ConnectionServer>>) => {
            state.connectionServers = action.payload;
        },
        setExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<ExternalDeployment>>) => {
            state.externalDeployments = action.payload;
        },
        setExternalDeploymentsCount: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.count = action.payload;
        },
        setIsLoading: (state: FolderExternalDeploymentsState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setMaxAge: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.maxAge = action.payload;
        },
        setSseStreamChannel: (state: FolderExternalDeploymentsState, action: PayloadAction<EventChannel<Event> | undefined>) => {
            state.externalDeploymentChannel = action.payload;
        },
        subscribeToSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        updateApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<UpdateStatusEvent>>) => noop(),
        unsubscribeFromSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        setCondition: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.condition = action.payload;
        },
    },
});
