import { EventChannel } from 'redux-saga';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { EventSource } from 'mocksse';
import { folderExternalDeployments, initialState } from './external-deployments.reducer';
import {
    CreateStatusEvent,
    DeleteStatusEvent,
    EndpointExternalDeploymentEvent,
    ExternalDeployment,
    ExternalDeploymentPage,
    UpdateStatusEvent,
} from '../external-deployment.types';
import { SSE_REGISTRATION_URL } from '../constants';
import { subscribeToSse } from '../helper/utils';
import { baseExternalDeploymentEventMock, connectionServersMock, deploymentStateMock, externalDeploymentMock } from '../__mocks__/external-deployments.mocks';

describe('external deployments reducer', () => {
    const {
        createApplicationStatus,
        deleteApplicationStatus,
        loadExternalDeployments,
        setConnectionServers,
        setIsLoading,
        setMaxAge,
        setSseStreamChannel,
        setExternalDeployments,
        setExternalDeploymentsCount,
        subscribeToSseStream,
        updateApplicationStatus,
        unsubscribeFromSseStream,
        setCondition,
    } = folderExternalDeployments.actions;

    it('should have the initial state', () => {
        expect(folderExternalDeployments.name).toBe('folderExternalDeployments');
        expect(folderExternalDeployments.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('createApplicationStatus', () => {
            it('should not update state', () => {
                const payload: EndpointExternalDeploymentEvent<CreateStatusEvent> = {
                    endpointId: '12',
                    state: {
                        ...baseExternalDeploymentEventMock,
                        statusGroup: 'success',
                        versionTag: { label: '1.0' },
                    },
                };
                const state = folderExternalDeployments.reducer(initialState, createApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('deleteApplicationStatus', () => {
            it('should not update state', () => {
                const payload: EndpointExternalDeploymentEvent<DeleteStatusEvent> = {
                    endpointId: '12',
                    state: {
                        ...baseExternalDeploymentEventMock,
                        versionTag: { label: '1.0' },
                    },
                };
                const state = folderExternalDeployments.reducer(initialState, deleteApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadExternalDeployments', () => {
            it('should update state', () => {
                const payload: ExternalDeploymentPage = {
                    folderId: 'folderId',
                    page: 1,
                    resultsPerPage: 25,
                    orderBy: 'environment',
                    order: 'desc',
                };
                const state = folderExternalDeployments.reducer(initialState, loadExternalDeployments(payload));
                expect(state.page).toStrictEqual(payload);
            });
        });

        describe('setConnectionServers', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setConnectionServers(connectionServersMock));
                expect(state.connectionServers).toStrictEqual(connectionServersMock);
            });
        });

        describe('setExternalDeployments', () => {
            it('should update state', () => {
                const payload: Array<ExternalDeployment> = [externalDeploymentMock];
                const state = folderExternalDeployments.reducer(initialState, setExternalDeployments(payload));
                expect(state.externalDeployments).toStrictEqual(payload);
            });
        });

        describe('setExternalDeploymentsCount', () => {
            it('should update state', () => {
                const payload: number = 100;
                const state = folderExternalDeployments.reducer(initialState, setExternalDeploymentsCount(payload));
                expect(state.count).toStrictEqual(payload);
            });
        });

        describe('setIsLoading', () => {
            it('should update state', () => {
                const payload = true;
                const state = folderExternalDeployments.reducer(initialState, setIsLoading(payload));
                expect(state.isLoading).toStrictEqual(payload);
            });
        });

        describe('setMaxAge', () => {
            it('should update state', () => {
                const payload = 20;
                const state = folderExternalDeployments.reducer(initialState, setMaxAge(payload));
                expect(state.maxAge).toStrictEqual(payload);
            });
        });

        describe('setSseStreamChannel', () => {
            it('should update state', () => {
                const mockEventSource = new EventSource(SSE_REGISTRATION_URL);
                const payload: EventChannel<Event> = subscribeToSse(mockEventSource);
                const state = folderExternalDeployments.reducer(initialState, setSseStreamChannel(payload));
                expect(state.externalDeploymentChannel).toStrictEqual(payload);
            });
        });

        describe('subscribeToSseStream', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, subscribeToSseStream());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('updateApplicationStatus', () => {
            it('should not update state', () => {
                const payload: EndpointExternalDeploymentEvent<UpdateStatusEvent> = {
                    endpointId: '12',
                    state: {
                        ...baseExternalDeploymentEventMock,
                        state: deploymentStateMock,
                        statusGroup: 'success',
                    },
                };
                const state = folderExternalDeployments.reducer(initialState, updateApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('unsubscribeFromSseStream', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, unsubscribeFromSseStream());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setCondition', () => {
            it('should update state', () => {
                const payload = 'condition';
                const state = folderExternalDeployments.reducer(initialState, setCondition(payload));
                expect(state.condition).toStrictEqual(payload);
            });
        });
    });
});
