import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ExternalDeploymentsTable } from './external-deployments-table.component';
import { folderExternalDeployments, FolderExternalDeploymentsState, initialState } from '../ducks/external-deployments.reducer';
import { connectionServersMock, externalDeploymentMock } from '../__mocks__/external-deployments.mocks';
import { DEFAULT_ORDER } from '../constants';

const { loadExternalDeployments, subscribeToSseStream, unsubscribeFromSseStream } = folderExternalDeployments.actions;
const dispatch = jest.fn();
describe('ExternalDeploymentsTable component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<ExternalDeploymentsTable {...defaultProps} />, dispatch, { folderExternalDeployments: state });
        expect(dispatch).toBeCalledWith(
            loadExternalDeployments({
                folderId: 'folderId',
                order: DEFAULT_ORDER,
                orderBy: 'status',
                resultsPerPage: 10,
                page: 0,
            }),
        );
        expect(dispatch).toBeCalledWith(subscribeToSseStream());
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
        expect(dispatch).toBeCalledWith(unsubscribeFromSseStream());
    });
    const searchTable = (selector: string) => wrapper.find(`.external-deployments-table ${selector}`);

    it('should show the title, search box and table heading with no results', () => {
        expect(searchTable('.dot-typography').at(0).text()).toStrictEqual('Application deployments (0)');
        expect(searchTable('.search input').props().placeholder).toStrictEqual('Type to filter');
        expect(searchTable('.dot-typography').at(1).text()).toStrictEqual('Application name');
        expect(searchTable('.dot-typography').at(2).text()).toStrictEqual('Environment');
        expect(searchTable('.dot-typography').at(3).text()).toStrictEqual('Version');
        expect(searchTable('.dot-typography').at(4).text()).toStrictEqual('Status');
        expect(searchTable('.dot-typography').at(5).text()).toStrictEqual('Updated');
    });

    it('should not show one row', () => {
        mountComponent({ ...defaultState, externalDeployments: [externalDeploymentMock] });
        expect(searchTable('.dot-typography').at(0).text()).toStrictEqual('Application deployments (1)');
        expect(searchTable('.external-deployment-card').exists()).toBeFalsy();
    });

    it('should show one row', () => {
        mountComponent({
            ...defaultState,
            count: 1,
            connectionServers: connectionServersMock,
            externalDeployments: [externalDeploymentMock],
        });
        expect(searchTable('.dot-typography').at(0).text()).toStrictEqual('Application deployments (1)');
        expect(searchTable('.external-deployment-card').exists()).toBeTruthy();
    });
});
