// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { EventSource } from 'mocksse';
import { getDeepLink, getServerIcon, getVersionLabel, registerEventSource, subscribeToSse, trimCommitHash } from './utils';
import { ENDPOINT_TYPE, IMG_SRC, SSE_REGISTRATION_URL } from '../constants';

describe('utils', () => {
    beforeAll(() => {
        global.EventSource = EventSource;
    });

    describe('registerEventSource', () => {
        it('should create new EventSource from url', () => {
            expect(registerEventSource(SSE_REGISTRATION_URL)).toMatchObject({
                _eventsCount: 0,
                CLOSED: 2,
                CONNECTING: 0,
                OPEN: 1,
                readyState: null,
                responses: [],
                url: SSE_REGISTRATION_URL,
            });
        });
    });

    describe('subscribeToSse', () => {
        it('should add event listeners for 5 events', () => {
            const eventSrc = registerEventSource(SSE_REGISTRATION_URL);
            const result = subscribeToSse(eventSrc);
            expect(result).toMatchObject({
                close: expect.any(Function),
                flush: expect.any(Function),
                take: expect.any(Function),
            });
        });
    });

    describe('getDeepLink', () => {
        it('should combine endpointUrl with applicationPath', () => {
            expect(getDeepLink('endp', 'oint')).toStrictEqual('endpoint');
        });
    });

    describe('getServerIcon', () => {
        it('should give icon for type, default is empty', () => {
            expect(getServerIcon(ENDPOINT_TYPE.deploy)).toStrictEqual(IMG_SRC.deploy);
            expect(getServerIcon(ENDPOINT_TYPE.argoCd)).toStrictEqual(IMG_SRC.argoCd);
            expect(getServerIcon('')).toStrictEqual('');
        });
    });

    describe('trimCommitHash', () => {
        it('should trim commit hash if its length exceeds 6', () => {
            expect(trimCommitHash('#d654f0c68f9213b19818ba23d91350886362431a')).toStrictEqual('#d654f0');
        });
        it('should return commit hash if its length is less than 6', () => {
            expect(trimCommitHash('#d654')).toStrictEqual('#d654');
        });
    });

    describe('getVersionLabel', () => {
        it('should trim ArgoCD version label', () => {
            expect(getVersionLabel(ENDPOINT_TYPE.argoCd, '#d654f0c68f9213b19818ba23d91350886362431a')).toStrictEqual('#d654f0');
        });
        it('should not trim Deploy version label', () => {
            expect(getVersionLabel(ENDPOINT_TYPE.deploy, '1.0')).toStrictEqual('1.0');
        });
    });
});
