import { END, EventChannel, eventChannel } from 'redux-saga';
import { ENDPOINT_TYPE, EVENT_TYPE, IMG_SRC } from '../constants';

export function registerEventSource(url: string): EventSource {
    return new EventSource(url);
}

export function subscribeToSse(eventSrc: EventSource): EventChannel<Event> {
    return eventChannel((emitter) => {
        eventSrc.onopen = (ev) => emitter(ev); //eslint-disable-line no-param-reassign
        eventSrc.addEventListener(EVENT_TYPE.applicationPackageCreated, (ev) => emitter(ev));
        eventSrc.addEventListener(EVENT_TYPE.applicationPackageDeleted, (ev) => emitter(ev));
        eventSrc.addEventListener(EVENT_TYPE.applicationCreated, (ev) => emitter(ev));
        eventSrc.addEventListener(EVENT_TYPE.applicationDeleted, (ev) => emitter(ev));
        eventSrc.addEventListener(EVENT_TYPE.applicationChanged, (ev) => emitter(ev));
        // eventSrc.onerror = (err) => console.error(err)

        return () => {
            eventSrc.close();
            emitter(END);
        };
    });
}

export const getDeepLink = (endpointUrl: string, applicationPath: string) => {
    return endpointUrl.replace(/\/+$/, '') + (applicationPath ? applicationPath : '');
};

export const getServerIcon = (serverType: string): string => {
    return (
        {
            [ENDPOINT_TYPE.deploy]: IMG_SRC.deploy,
            [ENDPOINT_TYPE.argoCd]: IMG_SRC.argoCd,
        }[serverType] || ''
    );
};

export const trimCommitHash = (hash: string): string => {
    if (hash.length > 6) return hash.substring(0, 7);
    else return hash;
};

export const getVersionLabel = (endpointType: string, label: string): string => {
    if (endpointType === ENDPOINT_TYPE.argoCd) return trimCommitHash(label);
    else return label;
};
