import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { EventChannel } from 'redux-saga';
import {
    ConnectionServer,
    CreateStatusEvent,
    DeleteStatusEvent,
    EndpointExternalDeploymentEvent,
    ExternalDeployment,
    UpdateStatusEvent,
} from '../external-deployment.types';
import { DEFAULT_MAX_AGE } from '../constants';

export interface FolderExternalDeploymentsState {
    connectionServers: Map<string, ConnectionServer>;
    externalDeploymentChannel?: EventChannel<Event>;
    externalDeployments: Array<ExternalDeployment>;
    folderId?: string;
    isLoading: boolean;
    maxAge: number;
}

export const initialState: FolderExternalDeploymentsState = {
    connectionServers: new Map<string, ConnectionServer>(),
    externalDeploymentChannel: undefined,
    externalDeployments: [],
    folderId: undefined,
    isLoading: false,
    maxAge: DEFAULT_MAX_AGE,
};

export const folderExternalDeployments = createSlice({
    name: 'folderExternalDeployments',
    initialState,
    reducers: {
        createApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<CreateStatusEvent>>) => noop(),
        deleteApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<DeleteStatusEvent>>) => noop(),
        loadExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.folderId = action.payload;
        },
        setConnectionServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Map<string, ConnectionServer>>) => {
            state.connectionServers = action.payload;
        },
        setExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<ExternalDeployment>>) => {
            state.externalDeployments = action.payload;
        },
        setIsLoading: (state: FolderExternalDeploymentsState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setMaxAge: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.maxAge = action.payload;
        },
        setSseStreamChannel: (state: FolderExternalDeploymentsState, action: PayloadAction<EventChannel<Event> | undefined>) => {
            state.externalDeploymentChannel = action.payload;
        },
        subscribeToSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        updateApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<UpdateStatusEvent>>) => noop(),
        unsubscribeFromSseStream: (_state: FolderExternalDeploymentsState) => noop(),
    },
});
