package com.xebialabs.xlrelease.scm.connector

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.domain.scm.connector.{BaseScmConnectorConfig, ScmConnectorConfig}
import com.xebialabs.xlrelease.service.ConfigurationStatusService
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.{Failure, Success, Using}

@Component
class ScmConfigurationStatusService @Autowired()() extends ConfigurationStatusService {
  override def supports(configuration: Configuration): Boolean = {
    configuration.getType.instanceOf(Type.valueOf(classOf[BaseScmConnectorConfig]))
  }

  override def checkStatus(configuration: Configuration): SharedConfigurationStatusResponse = {
    val basicScmConnectorConfig = configuration.asInstanceOf[ScmConnectorConfig]
    Using.resource(basicScmConnectorConfig.getConnector) { connector =>
      val status = connector.connectionStatus()
      status match {
        case Success(_) => new SharedConfigurationStatusResponse(true, true)
        case Failure(ex) => new SharedConfigurationStatusResponse(false, true, ex.getMessage)
      }
    }
  }
}
