package com.xebialabs.xlrelease.scm.connector.actors

import akka.actor.{ActorRef, Props}
import com.xebialabs.xlplatform.cluster.ClusterMode.{FULL, HOT_STANDBY, STANDALONE}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.config.XlrConfig
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component

import scala.concurrent.{Await, Promise}

@Component
class JGitRepoCleanerActorHolder @Autowired()(xlrConfig: XlrConfig) {
  private val actorPromise = Promise[ActorRef]()

  def actorRef(): ActorRef = {
    Await.result(actorPromise.future, xlrConfig.timeouts.systemInitialization)
  }

  def resolveActorRef(actorRef: ActorRef): Unit = {
    actorPromise.success(actorRef)
  }
}

@Component
@Profile(Array(STANDALONE, HOT_STANDBY))
class NonClusteredJGitRepoCleanerActorInitializer @Autowired()(systemHolder: ActorSystemHolder,
                                                               jGitRepoCleanerActorHolder: JGitRepoCleanerActorHolder)
  extends ActorInitializer {
  override def initialize(): Unit = {
    jGitRepoCleanerActorHolder.resolveActorRef(
      systemHolder.actorSystem.actorOf(
        Props(new NonClusteredJGitRepoCleanerActor())
      )
    )
  }
}

@Component
@Profile(Array(FULL))
class ClusteredJGitRepoCleanerActorInitializer @Autowired()(systemHolder: ActorSystemHolder,
                                                            jGitRepoCleanerActorHolder: JGitRepoCleanerActorHolder)
  extends ActorInitializer {
  override def initialize(): Unit = {
    jGitRepoCleanerActorHolder.resolveActorRef(
      systemHolder.actorSystem.actorOf(
        Props(new ClusteredJGitRepoCleanerActor())
      )
    )
  }
}