/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.JGitConnectorConfig;
import com.xebialabs.xlrelease.scm.connector.Blobs;
import com.xebialabs.xlrelease.scm.connector.GitClient;
import com.xebialabs.xlrelease.scm.connector.GitConnectionSettings;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.connector.ValidatedCommitInfo;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.util.FS;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005uu!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\u0002\u0003\u001e\u0002\u0011\u000b\u0007I\u0011A\u001e\t\u000b\u001d\u000bA\u0011\u0001%\t\u000f\u0005=\u0015\u0001\"\u0001\u0002\u0012\"9\u0011QS\u0001\u0005\u0002\u0005]\u0005BBAN\u0003\u0011%1H\u0002\u00031G\u0001Q\u0005\u0002\u0003(\t\u0005\u0003\u0005\u000b\u0011B(\t\u000baBA\u0011A,\t\u000feC!\u0019!C\u0001w!1!\f\u0003Q\u0001\nqBqa\u0017\u0005C\u0002\u0013%1\b\u0003\u0004]\u0011\u0001\u0006I\u0001\u0010\u0005\b;\"\u0011\r\u0011\"\u0001<\u0011\u0019q\u0006\u0002)A\u0005y!Iq\f\u0003a\u0001\u0002\u0004%\t\u0001\u0019\u0005\nI\"\u0001\r\u00111A\u0005\u0002\u0015D\u0011b\u001b\u0005A\u0002\u0003\u0005\u000b\u0015B1\t\u00131D\u0001\u0019!a\u0001\n\u0013i\u0007\"\u0003>\t\u0001\u0004\u0005\r\u0011\"\u0003|\u0011%i\b\u00021A\u0001B\u0003&a\u000eC\u0003\u007f\u0011\u0011\u0005s\u0010C\u0004\u0002\f!!\t%!\u0004\t\u000f\u0005m\u0001\u0002\"\u0015\u0002\u001e!9\u0011\u0011\b\u0005\u0005R\u0005m\u0002bBA%\u0011\u0011E\u00131\n\u0005\b\u0003\u001bBA\u0011BA(\u0011\u001d\tY\u0006\u0003C\u0005\u0003;Ba!!\u001d\t\t\u0013i\u0007bBA:\u0011\u0011%\u0011Q\u000f\u0005\b\u0003oBA\u0011BA\u0007\u0011\u001d\tI\b\u0003C\u0005\u0003w\nQBS$ji\u000e{gN\\3di>\u0014(B\u0001\u0013&\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002'O\u0005\u00191oY7\u000b\u0005!J\u0013!\u0003=me\u0016dW-Y:f\u0015\tQ3&A\u0005yK\nL\u0017\r\\1cg*\tA&A\u0002d_6\u001c\u0001\u0001\u0005\u00020\u00035\t1EA\u0007K\u000f&$8i\u001c8oK\u000e$xN]\n\u0003\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/\u0003M!UIR!V\u0019R{6kQ'`/>\u00136\nR%S+\u0005a\u0004CA\u001fE\u001d\tq$\t\u0005\u0002@i5\t\u0001I\u0003\u0002B[\u00051AH]8pizJ!a\u0011\u001b\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007R\nQ!\u00199qYf$2!SAG!\ty\u0003bE\u0002\te-\u0003\"a\f'\n\u00055\u001b#\u0001D*d[\u000e{gN\\3di>\u0014\u0018AB2p]\u001aLw\r\u0005\u0002Q+6\t\u0011K\u0003\u0002%%*\u0011ae\u0015\u0006\u0003)\u001e\na\u0001Z8nC&t\u0017B\u0001,R\u0005MQu)\u001b;D_:tWm\u0019;pe\u000e{gNZ5h)\tI\u0005\fC\u0003O\u0015\u0001\u0007q*\u0001\bgk2d'I]1oG\"t\u0015-\\3\u0002\u001f\u0019,H\u000e\u001c\"sC:\u001c\u0007NT1nK\u0002\n\u0001B]3q_:\fW.Z\u0001\ne\u0016\u0004xN\\1nK\u0002\n1B]3q_\u0012K'\u000fU1uQ\u0006a!/\u001a9p\t&\u0014\b+\u0019;iA\u0005Iq-\u001b;DY&,g\u000e^\u000b\u0002CB\u0011qFY\u0005\u0003G\u000e\u0012\u0011bR5u\u00072LWM\u001c;\u0002\u001b\u001dLGo\u00117jK:$x\fJ3r)\t1\u0017\u000e\u0005\u00024O&\u0011\u0001\u000e\u000e\u0002\u0005+:LG\u000fC\u0004k%\u0005\u0005\t\u0019A1\u0002\u0007a$\u0013'\u0001\u0006hSR\u001cE.[3oi\u0002\nAaX4jiV\ta\u000e\u0005\u0002pq6\t\u0001O\u0003\u0002re\u0006\u0019\u0011\r]5\u000b\u0005M$\u0018\u0001\u00026hSRT!!\u001e<\u0002\u000f\u0015\u001cG.\u001b9tK*\tq/A\u0002pe\u001eL!!\u001f9\u0003\u0007\u001dKG/\u0001\u0005`O&$x\fJ3r)\t1G\u0010C\u0004k+\u0005\u0005\t\u0019\u00018\u0002\u000b};\u0017\u000e\u001e\u0011\u0002\u001b\u001d,G/\u00133f]RLg-[3s)\ra\u0014\u0011\u0001\u0005\b\u0003\u00079\u0002\u0019AA\u0003\u0003\u0015\u0011Gn\u001c2t!\ry\u0013qA\u0005\u0004\u0003\u0013\u0019#!\u0002\"m_\n\u001c\u0018\u0001E2p]:,7\r^5p]N#\u0018\r^;t)\t\ty\u0001E\u0003\u0002\u0012\u0005]a-\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\t\u0019BA\u0002Uef\fAbY8n[&$\u0018I\u001c3UC\u001e$\u0002\"a\b\u0002\"\u0005\r\u0012Q\u0006\t\u0006\u0003#\t9\u0002\u0010\u0005\b\u0003\u0007I\u0002\u0019AA\u0003\u0011\u001d\t)#\u0007a\u0001\u0003O\t!bY8n[&$\u0018J\u001c4p!\ry\u0013\u0011F\u0005\u0004\u0003W\u0019#a\u0005,bY&$\u0017\r^3e\u0007>lW.\u001b;J]\u001a|\u0007bBA\u00183\u0001\u0007\u0011\u0011G\u0001\u0005kN,'\u000f\u0005\u0003\u00024\u0005UR\"A*\n\u0007\u0005]2KA\u0006Vg\u0016\u0014\bK]8gS2,\u0017!\u0004;bO:{G\u000f\u0015:fg\u0016tG\u000f\u0006\u0003\u0002>\u0005\u0015\u0003CBA\t\u0003/\ty\u0004E\u00024\u0003\u0003J1!a\u00115\u0005\u001d\u0011un\u001c7fC:Da!a\u0012\u001b\u0001\u0004a\u0014a\u0001;bO\u0006\u00012\r\\3b]V\u0004(+Z:pkJ\u001cWm\u001d\u000b\u0002M\u00069q-\u001b;Qk2dG\u0003BA)\u0003/\u00022a\\A*\u0013\r\t)\u0006\u001d\u0002\u000b!VdGNU3tk2$\bBBA-9\u0001\u0007a.A\u0002hSR\fqaZ5u!V\u001c\b\u000e\u0006\u0003\u0002`\u0005=\u0004\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0010%\u0016lw\u000e^3SK\u001a,\u0006\u000fZ1uK*\u0019\u0011\u0011\u000e:\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018\u0002BA7\u0003G\u0012aa\u0015;biV\u001c\bBBA-;\u0001\u0007a.\u0001\u0004hKR<\u0015\u000e^\u0001\tS:LGOU3q_R\ta.\u0001\u000bwKJLg-\u001f*fa>\u001c\u0018\u000e^8ssB\u000bG\u000f[\u0001\nO\u0016$\u0018)\u001e;i_J$B!! \u0002\nB!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004J\f1\u0001\\5c\u0013\u0011\t9)!!\u0003\u0017A+'o]8o\u0013\u0012,g\u000e\u001e\u0005\b\u0003\u0017\u000b\u0003\u0019AA\u0019\u0003-)8/\u001a:Qe>4\u0017\u000e\\3\t\u000b9#\u0001\u0019A(\u0002\u0015\u0011,G.\u001a;f%\u0016\u0004x\u000eF\u0002g\u0003'CQAT\u0003A\u0002=\u000b\u0001cZ3u\u0007>tg-[4ESJ\u0004\u0016\r\u001e5\u0015\u0007q\nI\nC\u0003O\r\u0001\u0007q*\u0001\bhKR<vN]6eSJ\u0004\u0016\r\u001e5")
public class JGitConnector
implements ScmConnector {
    private final JGitConnectorConfig config;
    private final String fullBranchName;
    private final String reponame;
    private final String repoDirPath;
    private GitClient gitClient;
    private Git _git;

    public static String getConfigDirPath(JGitConnectorConfig jGitConnectorConfig) {
        return JGitConnector$.MODULE$.getConfigDirPath(jGitConnectorConfig);
    }

    public static void deleteRepo(JGitConnectorConfig jGitConnectorConfig) {
        JGitConnector$.MODULE$.deleteRepo(jGitConnectorConfig);
    }

    public static JGitConnector apply(JGitConnectorConfig jGitConnectorConfig) {
        return JGitConnector$.MODULE$.apply(jGitConnectorConfig);
    }

    public static String DEFAULT_SCM_WORKDIR() {
        return JGitConnector$.MODULE$.DEFAULT_SCM_WORKDIR();
    }

    @Override
    public Try<String> createNewVersion(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return ScmConnector.createNewVersion$(this, blobs, commitInfo, user);
    }

    public String fullBranchName() {
        return this.fullBranchName;
    }

    private String reponame() {
        return this.reponame;
    }

    public String repoDirPath() {
        return this.repoDirPath;
    }

    public GitClient gitClient() {
        return this.gitClient;
    }

    public void gitClient_$eq(GitClient x$1) {
        this.gitClient = x$1;
    }

    private Git _git() {
        return this._git;
    }

    private void _git_$eq(Git x$1) {
        this._git = x$1;
    }

    @Override
    public String getIdentifier(Blobs blobs) {
        return new StringBuilder(1).append(this.config.url()).append("/").append(blobs.templateFilePath()).toString();
    }

    @Override
    public Try<BoxedUnit> connectionStatus() {
        Try refs = this.verifyRepositoryPath().flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Git.lsRemoteRepository().setRemote($this.config.url()).setHeads(true).setTags(false).callAsMap().keySet()).map((Function1 & Serializable)remoteRefs -> remoteRefs);
            return try_;
        });
        return refs.flatMap((Function1 & Serializable)r -> r.isEmpty() ? new Failure((Throwable)((Object)new ScmException("The remote repository is empty", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3()))) : (!r.contains(this.fullBranchName()) ? new Failure((Throwable)((Object)new ScmException(new StringBuilder(43).append("Branch ").append($this.config.branch()).append(" does not exist in remote repository").toString(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3()))) : new Success((Object)BoxedUnit.UNIT)));
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            RevCommit revCommit;
            Git git;
            block7: {
                block4: {
                    block6: {
                        RemoteRefUpdate.Status reAttemptPushStatus;
                        block5: {
                            RemoteRefUpdate.Status pushStatus;
                            git = this.getGit();
                            Repository repo = git.getRepository();
                            File templateFile = new File(repo.getDirectory().getParent(), blobs.templateFilePath());
                            templateFile.getParentFile().mkdirs();
                            File attachmentsDirectory = new File(repo.getDirectory().getParent(), blobs.attachments().folderName());
                            attachmentsDirectory.mkdirs();
                            Files.write(templateFile.toPath(), (byte[])blobs.dsl().getContent().apply(), new OpenOption[0]);
                            blobs.attachments().files().foreach((Function1 & Serializable)attachment -> {
                                File attachmentFile = new File(attachmentsDirectory, attachment.fileName());
                                return Files.write(attachmentFile.toPath(), (byte[])attachment.getContent().apply(), new OpenOption[0]);
                            });
                            git.add().addFilepattern(".").call();
                            PersonIdent committer = new PersonIdent(repo);
                            revCommit = git.commit().setCommitter(committer).setAuthor(this.getAuthor(user)).setMessage(commitInfo.message()).call();
                            git.tag().setAnnotated(false).setObjectId((RevObject)revCommit).setName(commitInfo.tag().refName()).call();
                            RemoteRefUpdate.Status status = pushStatus = this.gitPush(git);
                            boolean bl = RemoteRefUpdate.Status.NON_EXISTING.equals(status) ? true : RemoteRefUpdate.Status.REJECTED_OTHER_REASON.equals(status);
                            if (bl) {
                                JGitConnector$.MODULE$.deleteRepo($this.config);
                                throw new ScmException(new StringBuilder(46).append("Unable to push to remote repository. Status: [").append(pushStatus.name()).toString(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
                            }
                            boolean bl2 = RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD.equals(status) ? true : RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED.equals(status);
                            if (!bl2) break block4;
                            this.gitPull(git);
                            RemoteRefUpdate.Status status2 = reAttemptPushStatus = this.gitPush(git);
                            RemoteRefUpdate.Status status3 = RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD;
                            if (!(status2 == null ? status3 != null : !status2.equals(status3))) break block5;
                            RemoteRefUpdate.Status status4 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status5 = RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED;
                            if (!(status4 == null ? status5 != null : !status4.equals(status5))) break block5;
                            RemoteRefUpdate.Status status6 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status7 = RemoteRefUpdate.Status.NON_EXISTING;
                            if (!(status6 == null ? status7 != null : !status6.equals(status7))) break block5;
                            RemoteRefUpdate.Status status8 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status9 = RemoteRefUpdate.Status.REJECTED_OTHER_REASON;
                            if (status8 != null ? !status8.equals(status9) : status9 != null) break block6;
                        }
                        JGitConnector$.MODULE$.deleteRepo($this.config);
                        throw new ScmException(new StringBuilder(46).append("Unable to push to remote repository. Status: [").append(reAttemptPushStatus.name()).toString(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            git.push().setPushTags().call();
            return revCommit.getName();
        });
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Set tags = this.getGit().tagList().call().stream().map(x$5 -> x$5.getName()).collect(Collectors.toSet());
            return !tags.contains(new StringBuilder(10).append("refs/tags/").append(tag).toString());
        });
    }

    @Override
    public void cleanupResources() {
        block0: {
            if (this._git() == null) break block0;
            this._git().close();
            this._git_$eq(null);
        }
    }

    private PullResult gitPull(Git git) {
        return git.pull().setStrategy(MergeStrategy.THEIRS).call();
    }

    private RemoteRefUpdate.Status gitPush(Git git) {
        PushResult pushResultCommit = (PushResult)CollectionConverters$.MODULE$.IterableHasAsScala(git.push().call()).asScala().toList().head();
        return pushResultCommit.getRemoteUpdate(this.fullBranchName()).getStatus();
    }

    /*
     * WARNING - void declaration
     */
    private Git getGit() {
        Git git;
        if (this._git() != null) {
            git = this._git();
        } else {
            Git git2;
            File repoGitMetadataDir = new File(new StringBuilder(5).append(this.repoDirPath()).append("/.git").toString());
            boolean gitRepoExists = RepositoryCache.FileKey.isGitRepository((File)repoGitMetadataDir, (FS)FS.DETECTED);
            if (gitRepoExists) {
                void var3_3;
                Git tmpGit = Git.open((File)repoGitMetadataDir);
                tmpGit.reset().setMode(ResetCommand.ResetType.HARD).call();
                this.gitPull(tmpGit);
                git2 = var3_3;
            } else {
                git2 = this.initRepo();
            }
            this._git_$eq(git2);
            git = this._git();
        }
        return git;
    }

    private Git initRepo() {
        JGitConnector$.MODULE$.deleteRepo(this.config);
        File workDir = new File(this.repoDirPath());
        workDir.mkdirs();
        return Git.cloneRepository().setURI(this.config.url()).setDirectory(workDir).setBranchesToClone(Arrays.asList((Object[])new String[]{this.fullBranchName()})).setBranch(this.fullBranchName()).call();
    }

    private Try<BoxedUnit> verifyRepositoryPath() {
        return this.config.url() != null && ArrayOps$.MODULE$.lengthCompare$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.config.url()), '/')), 2)), 2) == 0 ? new Success((Object)BoxedUnit.UNIT) : new Failure((Throwable)((Object)new ScmException(new StringBuilder(26).append("Invalid repository format ").append(this.config.url()).toString(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3())));
    }

    private PersonIdent getAuthor(UserProfile userProfile) {
        return new PersonIdent(Strings.isNotBlank((String)userProfile.getFullName()) ? userProfile.getFullName() : userProfile.getCanonicalId(), Objects.toString(userProfile.getEmail(), ""));
    }

    public JGitConnector(JGitConnectorConfig config) {
        this.config = config;
        ScmConnector.$init$(this);
        this.fullBranchName = new StringBuilder(11).append("refs/heads/").append(config.branch()).toString();
        this.reponame = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(config.url()), '/')), 2)).mkString("_");
        this.repoDirPath = new StringBuilder(2).append(JGitConnector$.MODULE$.getConfigDirPath(config)).append("/").append(this.reponame()).append("_").append(config.branch()).toString();
        try {
            this.gitClient_$eq(new GitClient(new GitConnectionSettings(config.url(), config.branch(), config.authenticationMethod().name(), config.username(), PasswordEncrypter.getInstance().ensureDecrypted(config.password()), config.domain(), config.proxyHost(), config.proxyPort(), config.proxyUsername(), PasswordEncrypter.getInstance().ensureDecrypted(config.proxyPassword()), config.proxyDomain())));
        }
        catch (Exception e) {
            throw new ScmException("Unable to initialize git client with current settings", e, ScmException$.MODULE$.apply$default$3());
        }
    }
}

