/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubOAuth2Token;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubScmConnectorConfig;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubScmCredential;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubUsernamePasswordCredential;
import com.xebialabs.xlrelease.scm.connector.Attachments;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.Blobs;
import com.xebialabs.xlrelease.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.connector.ValidatedCommitInfo;
import java.io.Serializable;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\u0007\u000e\u0001aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006M\u0001!\ta\n\u0005\tU\u0001A)\u0019!C\u0005W!)a\b\u0001C)\u007f!)Q\t\u0001C)\r\")1\r\u0001C)I\")1\u000e\u0001C\u0005Y\")\u0011\u0010\u0001C\u0005u\u0016)q\u0010\u0001\u0001\u0002\u0002!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u0019\u0001\u0011%\u00111\u0007\u0002\u0013\u000f&$\b*\u001e2TG6\u001cuN\u001c8fGR|'O\u0003\u0002\u000f\u001f\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003!E\t1a]2n\u0015\t\u00112#A\u0005yYJ,G.Z1tK*\u0011A#F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AF\u0001\u0004G>l7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u00035I!\u0001H\u0007\u0003'I+7\u000f^!qSN\u001bWnQ8o]\u0016\u001cGo\u001c:\u0002\r\r|gNZ5h!\tyB%D\u0001!\u0015\tq\u0011E\u0003\u0002\u0011E)\u00111%E\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0015\u0002#\u0001G$ji\"+(mU2n\u0007>tg.Z2u_J\u001cuN\u001c4jO\u00061A(\u001b8jiz\"\"\u0001K\u0015\u0011\u0005i\u0001\u0001\"B\u000f\u0003\u0001\u0004q\u0012!B0sKB|W#\u0001\u0017\u0011\u00075\u0012D'D\u0001/\u0015\ty\u0003'\u0001\u0003vi&d'\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Mr#a\u0001+ssB\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0007O&$\b.\u001e2\u000b\u0005eR\u0014aB6pQN,8.\u001a\u0006\u0002w\u0005\u0019qN]4\n\u0005u2$\u0001D$I%\u0016\u0004xn]5u_JL\u0018A\u0004;fgR\u0014V\r]8tSR|'/_\u000b\u0002\u0001B\u0019QFM!\u0011\u0005\t\u001bU\"\u0001\u0019\n\u0005\u0011\u0003$\u0001B+oSR\fAbY8n[&$\u0018I\u001c3UC\u001e$BaR*Y;B\u0019QF\r%\u0011\u0005%\u0003fB\u0001&O!\tY\u0005'D\u0001M\u0015\tiu#\u0001\u0004=e>|GOP\u0005\u0003\u001fB\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q\n\r\u0005\u0006)\u0016\u0001\r!V\u0001\u0006E2|'m\u001d\t\u00035YK!aV\u0007\u0003\u000b\tcwNY:\t\u000be+\u0001\u0019\u0001.\u0002\u0015\r|W.\\5u\u0013:4w\u000e\u0005\u0002\u001b7&\u0011A,\u0004\u0002\u0014-\u0006d\u0017\u000eZ1uK\u0012\u001cu.\\7ji&sgm\u001c\u0005\u0006=\u0016\u0001\raX\u0001\u0005kN,'\u000f\u0005\u0002aC6\t!%\u0003\u0002cE\tYQk]3s!J|g-\u001b7f\u00035!\u0018m\u001a(piB\u0013Xm]3oiR\u0011Q-\u001b\t\u0004[I2\u0007C\u0001\"h\u0013\tA\u0007GA\u0004C_>dW-\u00198\t\u000b)4\u0001\u0019\u0001%\u0002\u0007Q\fw-A\u0012gS2$XM](vi\u0006c'/Z1esV\u0003Hn\\1eK\u0012\fE\u000f^1dQ6,g\u000e^:\u0015\t5\u0004(o\u001e\t\u000359L!a\\\u0007\u0003\u0017\u0005#H/Y2i[\u0016tGo\u001d\u0005\u0006c\u001e\u0001\r\u0001N\u0001\u0005e\u0016\u0004x\u000eC\u0003t\u000f\u0001\u0007A/\u0001\u0005cCN,GK]3f!\t)T/\u0003\u0002wm\t1q\t\u0013+sK\u0016DQ\u0001_\u0004A\u00025\f1\"\u0019;uC\u000eDW.\u001a8ug\u0006QAO]=D_:tWm\u0019;\u0015\u0003m\u00042!\f\u001a}!\t)T0\u0003\u0002\u007fm\t1q)\u001b;Ik\n\u00141BT1nK\u0012<\u0005J\u00117pEB1!)a\u0001I\u0003\u000fI1!!\u00021\u0005\u0019!V\u000f\u001d7feA\u0019Q'!\u0003\n\u0007\u0005-aG\u0001\u0004H\u0011\ncwNY\u0001\fkBdw.\u00193CY>\u00147\u000f\u0006\u0005\u0002\u0012\u0005%\u0012QFA\u0018!\u0011i#'a\u0005\u0011\r\u0005U\u0011qDA\u0013\u001d\u0011\t9\"a\u0007\u000f\u0007-\u000bI\"C\u00012\u0013\r\ti\u0002M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t#a\t\u0003\t1K7\u000f\u001e\u0006\u0004\u0003;\u0001\u0004cAA\u0014\u00135\t\u0001\u0001\u0003\u0004\u0002,)\u0001\r\u0001S\u0001\tM&dW\r]1uQ\")AK\u0003a\u0001+\")\u0011O\u0003a\u0001i\u0005Q1M]3bi\u0016$&/Z3\u0015\u0011\u0005U\u0012qGA\u001d\u0003{\u00012!\f\u001au\u0011\u0015\t8\u00021\u00015\u0011\u0019\tYd\u0003a\u0001\u0011\u0006Y!-Y:f)J,Wm\u00155b\u0011\u0019!6\u00021\u0001\u0002@A1\u0011QCA!\u0003KIA!a\u0011\u0002$\tA\u0011\n^3sC\ndW\r")
public class GitHubScmConnector
extends RestApiScmConnector {
    private Try<GHRepository> _repo;
    private final GitHubScmConnectorConfig config;
    private volatile boolean bitmap$0;

    private Try<GHRepository> _repo$lzycompute() {
        GitHubScmConnector gitHubScmConnector = this;
        synchronized (gitHubScmConnector) {
            if (!this.bitmap$0) {
                Try repo = this.tryConnect().map((Function1 & Serializable)gh -> gh.getRepository($this.config.repository()));
                this._repo = repo.recoverWith((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        HttpException httpException;
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof GHFileNotFoundException) {
                            GHFileNotFoundException gHFileNotFoundException = (GHFileNotFoundException)A1;
                            object = new Failure((Throwable)((Object)new ScmException("Repository not found", (Throwable)gHFileNotFoundException, 404)));
                        } else if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 401) {
                            object = new Failure((Throwable)((Object)new ScmException("Invalid credentials", (Throwable)httpException, 401)));
                        } else if (A1 instanceof Exception) {
                            Exception exception = (Exception)A1;
                            object = new Failure((Throwable)((Object)new ScmException(exception.getMessage(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3())));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        HttpException httpException;
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof GHFileNotFoundException ? true : (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 401 ? true : throwable instanceof Exception);
                        return bl;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this._repo;
    }

    private Try<GHRepository> _repo() {
        return !this.bitmap$0 ? this._repo$lzycompute() : this._repo;
    }

    @Override
    public Try<BoxedUnit> testRepository() {
        return this._repo().map((Function1 & Serializable)x$1 -> {
            GitHubScmConnector.$anonfun$testRepository$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this._repo().flatMap((Function1 & Serializable)repo -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef(new StringBuilder(6).append("heads/").append($this.config.branch()).toString())).recoverWith((PartialFunction)new Serializable(this, (GHRepository)repo){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ GitHubScmConnector $outer;
            private final GHRepository repo$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpException httpException;
                A1 A1 = x1;
                Object object = A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? this.$outer.com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(this.repo$2) : (A1 instanceof GHFileNotFoundException ? this.$outer.com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(this.repo$2) : function1.apply(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                HttpException httpException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? true : throwable instanceof GHFileNotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.repo$2 = repo$2;
            }
        }).flatMap((Function1 & Serializable)headRef -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getTree($this.config.branch())).map((Function1 & Serializable)baseTree -> {
            Blobs newBlobs = new Blobs(blobs.templateId(), blobs.dsl(), this.filterOutAlreadyUploadedAttachments((GHRepository)repo, (GHTree)baseTree, blobs.attachments()));
            return new Tuple2(baseTree, (Object)newBlobs);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GHTree baseTree = (GHTree)tuple2._1();
            Blobs newBlobs = (Blobs)tuple2._2();
            Try try_ = this.uploadBlobs(blobs.templateFilePath(), newBlobs, (GHRepository)repo).flatMap((Function1 & Serializable)ghNamedBlobs -> this.createTree((GHRepository)repo, baseTree.getSha(), (Iterable<Tuple2<String, GHBlob>>)ghNamedBlobs).flatMap((Function1 & Serializable)newTree -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createCommit().message(commitInfo.message()).tree(newTree.getSha()).parent(headRef.getObject().getSha()).create()).flatMap((Function1 & Serializable)commit -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createRef(commitInfo.tag().toString(), commit.getSHA1())).flatMap((Function1 & Serializable)x$3 -> {
                GHRef gHRef = x$3;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> headRef.updateTo(commit.getSHA1())).map((Function1 & Serializable)x$2 -> {
                    BoxedUnit boxedUnit = x$2;
                    String string = commit.getSHA1();
                    return string;
                });
                return try_;
            }))));
            return try_;
        })));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this._repo().map((Function1 & Serializable)repo -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$tagNotPresent$1(tag, repo)));
    }

    private Attachments filterOutAlreadyUploadedAttachments(GHRepository repo, GHTree baseTree, Attachments attachments) {
        Seq toUpload = attachments.files().isEmpty() ? (Seq)package$.MODULE$.Seq().empty() : (Seq)Option$.MODULE$.apply((Object)baseTree.getEntry("XLRelease")).flatMap((Function1 & Serializable)rootTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable)() -> rootTreeEntry.asTree()).toOption().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$3(x$5))).flatMap((Function1 & Serializable)rootTree -> Option$.MODULE$.apply((Object)rootTree.getEntry(".attachments")).flatMap((Function1 & Serializable)attachmentTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable)() -> attachmentTreeEntry.asTree()).toOption().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$7(x$6))).map((Function1 & Serializable)attachmentTree -> {
            BoxedUnit boxedUnit;
            Map filesMap = (Map)Map$.MODULE$.apply((Seq)attachments.files().map((Function1 & Serializable)file -> new Tuple2((Object)file.fileName(), file)));
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(attachmentTree.getTree()).asScala().view().takeWhile((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)filesMap.nonEmpty()))).foreach((Function1 & Serializable)entry -> (Map)filesMap.$minus$eq((Object)entry.getPath()));
            if (filesMap.nonEmpty() && attachmentTree.isTruncated()) {
                scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)filesMap.flatMap((Function1 & Serializable)filename -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getFileContent(new StringBuilder(1).append(attachments.folderName()).append("/").append(filename).toString(), $this.config.branch())).toOption().map((Function1 & Serializable)x$8 -> x$8.getName()));
                boxedUnit = filesMap.$minus$minus$eq((IterableOnce)toRemove);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return filesMap.values().toSeq();
        })))).getOrElse((Function0 & Serializable)() -> attachments.files());
        return new Attachments(attachments.folderName(), (Seq<BinaryFile>)toUpload);
    }

    private Try<GitHub> tryConnect() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GitHubBuilder gitHubBuilder;
            GitHubBuilder builder = new GitHubBuilder().withRateLimitHandler(RateLimitHandler.FAIL).withAbuseLimitHandler(AbuseLimitHandler.FAIL).withEndpoint($this.config.restApiUrl());
            GitHubScmCredential gitHubScmCredential = $this.config.credential();
            if (gitHubScmCredential instanceof GitHubUsernamePasswordCredential) {
                GitHubUsernamePasswordCredential gitHubUsernamePasswordCredential = (GitHubUsernamePasswordCredential)gitHubScmCredential;
                gitHubBuilder = builder.withPassword(gitHubUsernamePasswordCredential.username(), PasswordEncrypter.getInstance().ensureDecrypted(gitHubUsernamePasswordCredential.password()));
            } else if (gitHubScmCredential instanceof GitHubOAuth2Token) {
                GitHubOAuth2Token gitHubOAuth2Token = (GitHubOAuth2Token)gitHubScmCredential;
                gitHubBuilder = builder.withOAuthToken(PasswordEncrypter.getInstance().ensureDecrypted(gitHubOAuth2Token.token()));
            } else {
                if (gitHubScmCredential == null) {
                    throw new IllegalStateException(new StringBuilder(48).append("No credential provided for GitHub SCM config '").append($this.config.getTitle()).append("'.").toString());
                }
                throw new MatchError((Object)gitHubScmCredential);
            }
            return builder.build();
        });
    }

    private Try<List<Tuple2<String, GHBlob>>> uploadBlobs(String filepath, Blobs blobs, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ListBuffer ghBlobs = ListBuffer$.MODULE$.empty();
            ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filepath), (Object)repo.createBlob().binaryContent((byte[])blobs.dsl().getContent().apply()).create()));
            blobs.attachments().files().foreach((Function1 & Serializable)attachment -> (ListBuffer)ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(attachment.fileName()).toString()), (Object)repo.createBlob().binaryContent((byte[])attachment.getContent().apply()).create())));
            return ghBlobs.toList();
        });
    }

    private Try<GHTree> createTree(GHRepository repo, String baseTreeSha, Iterable<Tuple2<String, GHBlob>> blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHTreeBuilder builder = repo.createTree().baseTree(baseTreeSha);
            blobs.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String filename = (String)tuple2._1();
                GHBlob ghBlob = (GHBlob)tuple2._2();
                GHTreeBuilder gHTreeBuilder = builder.shaEntry(filename, ghBlob.getSha(), false);
                return gHTreeBuilder;
            });
            return builder.create();
        });
    }

    public static final /* synthetic */ void $anonfun$testRepository$1(GHRepository x$1) {
    }

    public final Try com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHRef defaultBranch = repo.getRef(new StringBuilder(6).append("heads/").append(repo.getDefaultBranch()).toString());
            return repo.createRef(new StringBuilder(11).append("refs/heads/").append($this.config.branch()).toString(), defaultBranch.getObject().getSha());
        });
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(String tag$1, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef(new StringBuilder(5).append("tags/").append(tag$1).toString())).failed().isSuccess();
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$3(GHTree x$5) {
        return x$5 != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$7(GHTree x$6) {
        return x$6 != null;
    }

    public GitHubScmConnector(GitHubScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

