import { initialState, remoteRunners } from './remote-runners.reducer';
import { remoteRunnerMock } from '../__mocks__/remote-runners.mocks';

describe('remote runners reducer', () => {
    const {
        setIsLoading,
        loadRemoteRunners,
        loadPermissions,
        setViewRunners,
        setEditRunners,
        setRemoteRunners,
        reloadRemoteRunners,
        updateRemoteRunnerState,
        deleteRemoteRunner,
    } = remoteRunners.actions;

    it('should have the initial state', () => {
        expect(remoteRunners.name).toBe('remoteRunners');
        expect(remoteRunners.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('setIsLoading', () => {
            it('should set isLoading', () => {
                const state = remoteRunners.reducer(initialState, setIsLoading(true));
                expect(state.isLoading).toStrictEqual(true);
            });
        });
        describe('loadRemoteRunners', () => {
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, loadRemoteRunners());
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('loadPermissions', () => {
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, loadPermissions());
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('setViewRunners', () => {
            it('should set userHasViewRunners to true', () => {
                const state = remoteRunners.reducer(initialState, setViewRunners(true));
                expect(state.userHasViewRunners).toStrictEqual(true);
            });

            it('should set userHasViewRunners to false', () => {
                const stateWithPermission = {
                    ...initialState,
                    userHasViewRunners: true,
                };
                const state = remoteRunners.reducer(stateWithPermission, setViewRunners(false));
                expect(state.userHasViewRunners).toStrictEqual(false);
            });
        });
        describe('setEditRunners', () => {
            it('should set userHasEditRunners to true', () => {
                const state = remoteRunners.reducer(initialState, setEditRunners(true));
                expect(state.userHasEditRunners).toStrictEqual(true);
            });

            it('should set userHasEditRunners to false', () => {
                const stateWithPermission = {
                    ...initialState,
                    userHasEditRunners: true,
                };
                const state = remoteRunners.reducer(stateWithPermission, setEditRunners(false));
                expect(state.userHasEditRunners).toStrictEqual(false);
            });
        });
        describe('setRemoteRunners', () => {
            const runners = [remoteRunnerMock];
            it('should set remote runners', () => {
                const state = remoteRunners.reducer(initialState, setRemoteRunners(runners));
                expect(state.remoteRunners).toStrictEqual(runners);
            });
        });
        describe('reloadRemoteRunners', () => {
            it('should not update state', () => {
                const payload = {
                    id: '',
                    isUpdate: false,
                };
                const state = remoteRunners.reducer(initialState, reloadRemoteRunners(payload));
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('updateRemoteRunnerState', () => {
            const payload = {
                id: remoteRunnerMock.id,
                enable: false,
            };
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, updateRemoteRunnerState(payload));
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('deleteRemoteRunner', () => {
            it('should not update state', () => {
                const state = remoteRunners.reducer(initialState, deleteRemoteRunner(remoteRunnerMock));
                expect(state).toStrictEqual(initialState);
            });
        });
    });
});
