/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.runner.impl.ContainerExecutionResultEvent;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\b\u0010\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r\t\u0004\u0001\u0015!\u0003H\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0019y\u0007\u0001\"\u0011\u00022!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\ti\b\u0001C\u0001\u0003\u007f\u0012qCU;o]\u0016\u00148k\u0019:jaR\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005A\t\u0012\u0001B5na2T!AE\n\u0002\rI,hN\\3s\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0005\u0001m\tS\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aD\u0005\u0003I=\u00111CU;o]\u0016\u00148k\u0019:jaR\u001cVM\u001d<jG\u0016\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003)\n\u0001b\u001a:jujdW\rZ\u0005\u0003Y\u001d\u0012q\u0001T8hO&tw-A\u0005yYJ\u001cuN\u001c4jOB\u0011qFM\u0007\u0002a)\u0011\u0011gE\u0001\u0007G>tg-[4\n\u0005M\u0002$!\u0003-me\u000e{gNZ5h\u0003AQwN\u0019*v]:,'oU3sm&\u001cW\r\u0005\u0002#m%\u0011qg\u0004\u0002\u0011\u0015>\u0014'+\u001e8oKJ\u001cVM\u001d<jG\u0016\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005ijT\"A\u001e\u000b\u0005q\u001a\u0012aB:feZL7-Z\u0005\u0003}m\u0012\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011\t%i\u0011#\u0011\u0005\t\u0002\u0001\"B\u0017\u0005\u0001\u0004q\u0003\"\u0002\u001b\u0005\u0001\u0004)\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0014\u0001\u0005:fgB|gn]3Qe>l\u0017n]3t+\u00059\u0005\u0003\u0002%N\u001fjk\u0011!\u0013\u0006\u0003\u0015.\u000b!bY8oGV\u0014(/\u001a8u\u0015\taU$\u0001\u0006d_2dWm\u0019;j_:L!AT%\u0003\u000fQ\u0013\u0018.Z'baB\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\u000f\u000e\u0003MS!\u0001V\r\u0002\rq\u0012xn\u001c;?\u0013\t1V$\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u001e!\rYVlX\u0007\u00029*\u0011!*H\u0005\u0003=r\u0013q\u0001\u0015:p[&\u001cX\r\u0005\u0002#A&\u0011\u0011m\u0004\u0002\u001e\u0007>tG/Y5oKJ,\u00050Z2vi&|gNU3tk2$XI^3oi\u0006\t\"/Z:q_:\u001cX\r\u0015:p[&\u001cXm\u001d\u0011\u0002\u0019=\u0014'.Z2u\u001b\u0006\u0004\b/\u001a:\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0011\u0011\fG/\u00192j]\u0012T!A[6\u0002\u000f)\f7m[:p]*\u0011AnF\u0001\nM\u0006\u001cH/\u001a:y[2L!A\\4\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u001b\u0015DXmY;uKN\u001b'/\u001b9u+\t\tH\u000fF\u0004s{~\fI!!\b\u0011\u0005M$H\u0002\u0001\u0003\u0006k\"\u0011\rA\u001e\u0002\u0002)F\u0011qO\u001f\t\u00039aL!!_\u000f\u0003\u000f9{G\u000f[5oOB\u0011Ad_\u0005\u0003yv\u00111!\u00118z\u0011\u0015q\b\u00021\u0001P\u0003\u0019\u00198M]5qi\"9\u0011\u0011\u0001\u0005A\u0002\u0005\r\u0011\u0001D2ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\b\u0003\u0002)\u0002\u0006=K1!a\u0002Z\u0005\r\u0019V\r\u001e\u0005\b\u0003\u0017A\u0001\u0019AA\u0007\u0003=Ig\u000e];u!\u0006\u0014\u0018-\\3uKJ\u001c\bCBA\b\u00033y5$\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!a\u0007\u0002\u0012\t\u0019Q*\u00199\t\u000f\u0005}\u0001\u00021\u0001\u0002\"\u0005iA/\u001f9f%\u00164WM]3oG\u0016\u0004R!a\t\u0002.Il!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005if\u0004XMC\u0002\u0002,%\fAaY8sK&!\u0011qFA\u0013\u00055!\u0016\u0010]3SK\u001a,'/\u001a8dKV!\u00111GA%)!\t)$a\u0013\u0002N\u0005=\u0003CBA\u001c\u0003\u0003\n9E\u0004\u0003\u0002:\u0005ubb\u0001*\u0002<%\ta$C\u0002\u0002@u\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002D\u0005\u0015#A\u0002,fGR|'OC\u0002\u0002@u\u00012a]A%\t\u0015)\u0018B1\u0001w\u0011\u0015q\u0018\u00021\u0001P\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007Aq!a\u0003\n\u0001\u0004\ti!\u0001\ffq\u0016\u001cW\u000f^3TGJL\u0007\u000f\u001e$pe>\u0013'.Z2u+\u0011\t)&!\u0017\u0015\u0011\u0005]\u00131LA/\u0003?\u00022a]A-\t\u0015)(B1\u0001w\u0011\u0015q(\u00021\u0001P\u0011\u001d\t\tA\u0003a\u0001\u0003\u0007Aq!a\u0003\u000b\u0001\u0004\ti!\u0001\nfq\u0016\u001cW\u000f^3P]\u000e{g\u000e^1j]\u0016\u0014HcB0\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\u0006}.\u0001\ra\u0014\u0005\b\u0003\u0003Y\u0001\u0019AA\u0002\u0011\u001d\tYa\u0003a\u0001\u0003\u001b\tab]2sSB$X\t_3dkR,G\r\u0006\u0004\u0002p\u0005U\u0014\u0011\u0010\t\u00049\u0005E\u0014bAA:;\t!QK\\5u\u0011\u0019\t9\b\u0004a\u0001\u001f\u0006\t2o\u0019:jaR,\u00050Z2vi&|g.\u00133\t\u000f\u0005mD\u00021\u0001\u0002\u000e\u00059\u0001/Y=m_\u0006$\u0017aH8o\u0007>tG/Y5oKJ,\u00050Z2vi&|gNU3tk2$XI^3oiR!\u0011qNAA\u0011\u0019\t\u0019)\u0004a\u0001?\u0006A!/Z:q_:\u001cX\rK\u0002\u000e\u0003\u000f\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u001b\u0012AB3wK:$8/\u0003\u0003\u0002\u0012\u0006-%AD!ts:\u001c7+\u001e2tGJL'-\u001a\u0015\u0004\u0001\u0005U\u0005\u0003BAL\u0003Kk!!!'\u000b\t\u0005m\u0015QT\u0001\u000bgR,'/Z8usB,'\u0002BAP\u0003C\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003G\u000b1a\u001c:h\u0013\u0011\t9+!'\u0003\u000fM+'O^5dK\"\u001a\u0001!a+\u0011\t\u0005%\u0015QV\u0005\u0005\u0003_\u000bYIA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d")
public class RunnerScriptServiceImpl
implements RunnerScriptService,
Logging {
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private final BroadcastService broadcastService;
    private final TrieMap<String, Promise<ContainerExecutionResultEvent>> responsePromises;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private TrieMap<String, Promise<ContainerExecutionResultEvent>> responsePromises() {
        return this.responsePromises;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    @Override
    public <T> T executeScript(String script, Set<String> capabilities, Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, capabilities, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + error);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> Vector<T> executeScript(String script, Set<String> capabilities, Map<String, Object> inputParameters) {
        Some some;
        Object commandResponse;
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, capabilities, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some && (commandResponse = (some = (Some)option).value()) instanceof List) {
            List list = (List)commandResponse;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)resultItem -> {
                String nodeString = this.objectMapper().writeValueAsString(resultItem);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object result = success.value();
                    this.logger().debug((Function0 & Serializable)() -> "Container script " + script + " executed successfully");
                    return result;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
                }
                throw new MatchError((Object)try_);
            })).toVector();
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + error);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> T executeScriptForObject(String script, Set<String> capabilities, Map<String, Object> inputParameters) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, capabilities, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            String nodeString = this.objectMapper().writeValueAsString(commandResponse);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                this.logger().debug((Function0 & Serializable)() -> "Container script " + script + " executed successfully");
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey()));
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ContainerExecutionResultEvent executeOnContainer(String script, Set<String> capabilities, Map<String, Object> inputParameters) {
        ContainerExecutionResultEvent containerExecutionResultEvent;
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor(capabilities);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "Cannot find active remote runner for executing script '" + script + "'");
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        String scriptExecutionId = runner2.execute((RemoteExecution)scriptTask);
        Promise responsePromise = Promise$.MODULE$.apply();
        this.responsePromises().put((Object)scriptExecutionId, (Object)responsePromise);
        try {
            containerExecutionResultEvent = (ContainerExecutionResultEvent)Await$.MODULE$.result((Awaitable)responsePromise.future(), (Duration)this.xlrConfig.timeouts().releaseActionResponse());
        }
        catch (TimeoutException e) {
            this.logger().error((Function0 & Serializable)() -> "Execution of script '" + script + "' timed out");
            throw new ContainerScriptException("Execution of script '" + script + "' timed out: " + e.getMessage());
        }
        return containerExecutionResultEvent;
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, Map<String, Object> payload) {
        ContainerExecutionResultEvent response = new ContainerExecutionResultEvent(scriptExecutionId, payload);
        this.logger().debug((Function0 & Serializable)() -> "Sending execution response for " + scriptExecutionId);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)response, true);
    }

    @AsyncSubscribe
    public void onContainerExecutionResultEvent(ContainerExecutionResultEvent response) {
        this.logger().debug((Function0 & Serializable)() -> "Received execution response for " + response.scriptExecutionId());
        this.responsePromises().get((Object)response.scriptExecutionId()).foreach((Function1 & Serializable)promise -> {
            Promise promise2;
            try {
                try {
                    promise2 = promise.success((Object)response);
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Failed to complete promise for " + response.scriptExecutionId() + ": " + e.getMessage());
                    promise2 = BoxedUnit.UNIT;
                }
            }
            finally {
                this.responsePromises().remove((Object)response.scriptExecutionId());
            }
            return promise2;
        });
    }

    public RunnerScriptServiceImpl(XlrConfig xlrConfig, JobRunnerService jobRunnerService, BroadcastService broadcastService) {
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
        this.responsePromises = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

