package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.runner.domain.RunnerId
import com.xebialabs.xlrelease.runner.impl.RunnerControlChannelActor._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor.{ConfirmCommand, RunnerAlive}
import com.xebialabs.xlrelease.runner.impl.spring.RemoteJobRunnerConfiguration.RunnerProxyActorHolder
import org.springframework.stereotype.Service

import jakarta.ws.rs.sse.{Sse, SseEventSink}

@Service
class RunnerControlService(actorSystemHolder: ActorSystemHolder, runnerProxyActorHolder: RunnerProxyActorHolder) {

  private lazy val runnerChannelRef = actorSystemHolder.actorOf(classOf[RunnerControlChannelSupervisor], "runnerControlChannelSupervisor")

  def watch(runnerId: RunnerId, sink: SseEventSink, sse: Sse): Unit = {
    runnerChannelRef ! OpenControlChannel(runnerId, sink, sse)
  }

  def closeControlChannel(runnerId: RunnerId): Unit = {
    runnerChannelRef ! CloseControlChannel(runnerId)
  }

  def confirmCommand(runnerId: RunnerId, commandId: String): Unit = {
    runnerProxyActorHolder ! ConfirmCommand(runnerId, commandId)
  }

  def alive(runnerId: RunnerId, timestamp: Long): Unit = {
    runnerProxyActorHolder ! RunnerAlive(runnerId, timestamp)
  }

}
