/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.xebialabs.xlrelease.actors.ManagedActor;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor;
import com.xebialabs.xlrelease.service.ConfigurationService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.slf4j.Marker;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007\"B5\u0001\t\u0003Q\u0007\"B>\u0001\t\u0013a\bbBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t\t\u0007\u0001C\u0005\u0003G\u0012\u0011DU;o]\u0016\u0014\u0018I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dK*\u0011q\u0002E\u0001\u0005S6\u0004HN\u0003\u0002\u0012%\u00051!/\u001e8oKJT!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!B:mMRR'\"A\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003YI\taaY8oM&<\u0017B\u0001\u0018,\u0005%AFN]\"p]\u001aLw-A\nk_\n\u0014VO\u001c8feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022i5\t!G\u0003\u00024%\u0005Q!/\u001a9pg&$xN]=\n\u0005U\u0012$a\u0005&pEJ+hN\\3s%\u0016\u0004xn]5u_JL\u0018A\u0006:v]:,'\u000f\u0015:pqf\f5\r^8s\u0011>dG-\u001a:\u0011\u0005abeBA\u001dJ\u001d\tQtI\u0004\u0002<\r:\u0011A(\u0012\b\u0003{\u0011s!AP\"\u000f\u0005}\u0012U\"\u0001!\u000b\u0005\u0005C\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t)b#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!\u0001\u0013\b\u0002\rM\u0004(/\u001b8h\u0013\tQ5*\u0001\u000fSK6|G/\u001a&pEJ+hN\\3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005!s\u0011BA'O\u0005Y\u0011VO\u001c8feB\u0013x\u000e_=BGR|'\u000fS8mI\u0016\u0014(B\u0001&L\u0003Q\u0019wN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKB\u0011\u0011\u000bV\u0007\u0002%*\u00111KE\u0001\bg\u0016\u0014h/[2f\u0013\t)&K\u0001\u000bD_:4\u0017nZ;sCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baS6\fX/\u0011\u0005e\u0003Q\"\u0001\b\t\u000b!*\u0001\u0019A\u0015\t\u000b=*\u0001\u0019\u0001\u0019\t\u000bY*\u0001\u0019A\u001c\t\u000b=+\u0001\u0019\u0001)\u0002#\u00054\u0018-\u001b7bE2,\u0007K]8qKJ$\u00180F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0003mC:<'\"A3\u0002\t)\fg/Y\u0005\u0003O\n\u0014aa\u0015;sS:<\u0017AE1wC&d\u0017M\u00197f!J|\u0007/\u001a:us\u0002\nQ!\u00197jm\u0016$\"a\u001b8\u0011\u0005ma\u0017BA7\u001d\u0005\u0011)f.\u001b;\t\u000b=D\u0001\u0019\u00019\u0002\u0011I,hN\\3s\u0013\u0012\u0004\"!\u001d=\u000f\u0005I,hBA\u001et\u0013\t!\b#\u0001\u0004e_6\f\u0017N\\\u0005\u0003m^\fq\u0001]1dW\u0006<WM\u0003\u0002u!%\u0011\u0011P\u001f\u0002\t%Vtg.\u001a:JI*\u0011ao^\u0001\u0019G\",7m\u001b*v]:,'o]!wC&d\u0017MY5mSRLH#A6)\u0015%q\u0018QCA\f\u00033\t9\u0002E\u0002\u0000\u0003#i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0004\u0003\u0013\t!b]2iK\u0012,H.\u001b8h\u0015\u0011\tY!!\u0004\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0014\u0005\u0005!!C*dQ\u0016$W\u000f\\3e\u00031Ig.\u001b;jC2$U\r\\1z=\r\u0001!\u001eY\u0001\nM&DX\r\u001a*bi\u0016\fq\"[:Sk:tWM]#ya&\u0014X\r\u001a\u000b\t\u0003?\t)#a\r\u0002FA\u00191$!\t\n\u0007\u0005\rBDA\u0004C_>dW-\u00198\t\rEQ\u0001\u0019AA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bA\t\u0002.)\u0011AOE\u0005\u0005\u0003c\tYCA\u0005K_\n\u0014VO\u001c8fe\"9\u0011Q\u0007\u0006A\u0002\u0005]\u0012\u0001\u00027bgR\u0004B!!\u000f\u0002@9\u0019!(a\u000f\n\u0007\u0005ub\"\u0001\tSk:tWM\u001d)s_bL\u0018i\u0019;pe&!\u0011\u0011IA\"\u0005Ya\u0015m\u001d;Sk:tWM\u001d+j[\u0016\u0014Vm\u001d9p]N,'bAA\u001f\u001d!9\u0011q\t\u0006A\u0002\u0005%\u0013aC2veJ,g\u000e\u001e+j[\u0016\u00042aGA&\u0013\r\ti\u0005\b\u0002\u0005\u0019>tw-\u0001\rnCB\u0014VO\u001c8feR{G*Y:u)&lW-\u00117jm\u0016$B!a\u0015\u0002`A91$!\u0016\u0002(\u0005e\u0013bAA,9\t1A+\u001e9mKJ\u0002RaGA.\u0003oI1!!\u0018\u001d\u0005\u0019y\u0005\u000f^5p]\"1\u0011c\u0003a\u0001\u0003O\t\u0001$\u001e9eCR,'+\u001e8oKJ\fe/Y5mC\nLG.\u001b;z)\u0015Y\u0017QMA4\u0011\u0019\tB\u00021\u0001\u0002(!9\u0011\u0011\u000e\u0007A\u0002\u0005}\u0011!C1wC&d\u0017M\u00197fQ\r\u0001\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)!\u00111OA\u0005\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003o\n\tHA\u0004TKJ4\u0018nY3")
public class RunnerAvailabilityService
implements Logging {
    private final XlrConfig xlrConfig;
    private final JobRunnerRepository jobRunnerRepository;
    private final ManagedActor<RunnerProxyActor> runnerProxyActorHolder;
    private final ConfigurationService configurationService;
    private final String availableProperty;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerAvailabilityService runnerAvailabilityService = this;
        synchronized (runnerAvailabilityService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private String availableProperty() {
        return this.availableProperty;
    }

    public void alive(String runnerId) {
        this.jobRunnerRepository.findRunner(runnerId).foreach((Function1 & Serializable)runner -> {
            RunnerAvailabilityService.$anonfun$alive$1(this, runner);
            return BoxedUnit.UNIT;
        });
    }

    @Scheduled(initialDelay=60000L, fixedRate=60000L)
    private void checkRunnersAvailability() {
        long currentTime = System.currentTimeMillis();
        ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jobRunnerRepository.findAll()).asScala().map((Function1 & Serializable)runner -> this.mapRunnerToLastTimeAlive((JobRunner)runner))).collect((PartialFunction)new Serializable(this, currentTime){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RunnerAvailabilityService $outer;
            private final long currentTime$1;

            public final <A1 extends Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    RunnerProxyActor.LastRunnerTimeResponse last;
                    JobRunner runner = (JobRunner)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(runner, last = (RunnerProxyActor.LastRunnerTimeResponse)(some = (Some)option).value(), this.currentTime$1)) {
                        return (B1)runner;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> x1) {
                Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> tuple2 = x1;
                if (tuple2 != null) {
                    Some some;
                    RunnerProxyActor.LastRunnerTimeResponse last;
                    JobRunner runner = (JobRunner)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some && this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(runner, last = (RunnerProxyActor.LastRunnerTimeResponse)(some = (Some)option).value(), this.currentTime$1)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTime$1 = currentTime$1;
            }
        })).foreach((Function1 & Serializable)runner -> {
            RunnerAvailabilityService.$anonfun$checkRunnersAvailability$3(this, runner);
            return BoxedUnit.UNIT;
        });
    }

    public boolean com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(JobRunner runner, RunnerProxyActor.LastRunnerTimeResponse last, long currentTime) {
        return runner.isAvailable() && last.timestamp().isDefined() && Predef$.MODULE$.Integer2int(runner.idleTimeToLive()) > 0 && currentTime - BoxesRunTime.unboxToLong((Object)last.timestamp().get()) > (long)(Predef$.MODULE$.Integer2int(runner.idleTimeToLive()) * 1000);
    }

    private Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> mapRunnerToLastTimeAlive(JobRunner runner) {
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActorReceive());
        Option lastTimeAlive = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            RunnerProxyActor.LastRunnerTime x$1 = new RunnerProxyActor.LastRunnerTime(runner.getId());
            Timeout x$2 = askTimeout;
            ActorRef x$3 = $this.runnerProxyActorHolder.$qmark$default$3((Object)x$1);
            return (RunnerProxyActor.LastRunnerTimeResponse)Await$.MODULE$.result((Awaitable)$this.runnerProxyActorHolder.$qmark((Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }).toOption();
        return new Tuple2((Object)runner, (Object)lastTimeAlive);
    }

    private void updateRunnerAvailability(JobRunner runner, boolean available) {
        runner.setProperty(this.availableProperty(), (Object)BoxesRunTime.boxToBoolean((boolean)available));
        this.configurationService.createOrUpdate((BaseConfiguration)runner);
    }

    public static final /* synthetic */ void $anonfun$alive$1(RunnerAvailabilityService $this, JobRunner runner) {
        if (!runner.isAvailable()) {
            $this.logger().info((Function0 & Serializable)() -> "Unavailable runner '" + runner.getId() + "' confirmed it's alive again and will be marked as available");
            $this.updateRunnerAvailability(runner, true);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkRunnersAvailability$3(RunnerAvailabilityService $this, JobRunner runner) {
        $this.logger().warn((Function0 & Serializable)() -> "Runner '" + runner.getId() + "' failed to confirm it's alive for more than " + runner.idleTimeToLive() + " seconds and will be marked as unavailable");
        $this.updateRunnerAvailability(runner, false);
    }

    public RunnerAvailabilityService(XlrConfig xlrConfig, JobRunnerRepository jobRunnerRepository, ManagedActor<RunnerProxyActor> runnerProxyActorHolder, ConfigurationService configurationService) {
        this.xlrConfig = xlrConfig;
        this.jobRunnerRepository = jobRunnerRepository;
        this.runnerProxyActorHolder = runnerProxyActorHolder;
        this.configurationService = configurationService;
        Logging.$init$((Logging)this);
        this.availableProperty = "available";
    }
}

