/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.xebialabs.deployit.ServerState;
import com.xebialabs.xlrelease.runner.api.v1.JobRunnerResource;
import com.xebialabs.xlrelease.runner.domain.JobDirective;
import com.xebialabs.xlrelease.runner.domain.JobResult;
import com.xebialabs.xlrelease.runner.impl.RunnerAvailabilityService;
import com.xebialabs.xlrelease.runner.impl.RunnerControlService;
import com.xebialabs.xlrelease.runner.service.RunnerJobService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\u0007\u000f\u0001eA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003G\u0001\u0011\u0005s\tC\u0003k\u0001\u0011\u00053\u000eC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\t)\t\u0001C!\u0003\u000f\u0013QCS8c%Vtg.\u001a:SKN|WO]2f\u00136\u0004HN\u0003\u0002\u0010!\u0005!\u0011.\u001c9m\u0015\t\t\"#\u0001\u0004sk:tWM\u001d\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001bA!\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\t1\u0018G\u0003\u0002&!\u0005\u0019\u0011\r]5\n\u0005\u001d\u0012#!\u0005&pEJ+hN\\3s%\u0016\u001cx.\u001e:dKB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006g24GG\u001b\u0006\u0002[\u0005AqM]5{u2,G-\u0003\u00020U\t9Aj\\4hS:<\u0017\u0001\u0005:v]:,'OS8c'\u0016\u0014h/[2f!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0004tKJ4\u0018nY3\n\u0005Y\u001a$\u0001\u0005*v]:,'OS8c'\u0016\u0014h/[2f\u0003Q\u0011XO\u001c8fe\u000e{g\u000e\u001e:pYN+'O^5dKB\u0011\u0011HO\u0007\u0002\u001d%\u00111H\u0004\u0002\u0015%Vtg.\u001a:D_:$(o\u001c7TKJ4\u0018nY3\u00023I,hN\\3s\u0003Z\f\u0017\u000e\\1cS2LG/_*feZL7-\u001a\t\u0003syJ!a\u0010\b\u00033I+hN\\3s\u0003Z\f\u0017\u000e\\1cS2LG/_*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\t\u001bE)\u0012\t\u0003s\u0001AQ\u0001\r\u0003A\u0002EBQa\u000e\u0003A\u0002aBQ\u0001\u0010\u0003A\u0002u\n!B]3tKJ4XMS8c)\rAe\f\u001b\t\u0003\u0013ns!AS-\u000f\u0005-CfB\u0001'X\u001d\tieK\u0004\u0002O+:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%b\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005U1\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002&!%\u00111\u0005J\u0005\u00035\n\n\u0011CS8c%Vtg.\u001a:SKN|WO]2f\u0013\taVL\u0001\fK_\n\u0014Vm]3sm\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0015\tQ&\u0005C\u0003`\u000b\u0001\u0007\u0001-\u0001\u0005sk:tWM]%e!\t\tWM\u0004\u0002cGB\u0011\u0001\u000bH\u0005\u0003Ir\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A\r\b\u0005\u0006S\u0016\u0001\r\u0001Y\u0001\ne\u0016\fX/Z:u\u0013\u0012\f!bY8oM&\u0014XNS8c)\u0015awn_A\u0001!\tIU.\u0003\u0002o;\n!2i\u001c8gSJl\u0017\r^5p]J+7\u000f]8og\u0016DQa\u0018\u0004A\u0002A\u0004\"!\u001d=\u000f\u0005I,hB\u0001't\u0013\t!\b#\u0001\u0004e_6\f\u0017N\\\u0005\u0003m^\fq\u0001]1dW\u0006<WM\u0003\u0002u!%\u0011\u0011P\u001f\u0002\t%Vtg.\u001a:JI*\u0011ao\u001e\u0005\u0006y\u001a\u0001\r!`\u0001\u0006U>\u0014\u0017\n\u001a\t\u0003czL!a >\u0003\u000b){'-\u00133\t\u000b%4\u0001\u0019\u00011\u0002\u0013\u0019Lg.[:i\u0015>\u0014Gc\u00027\u0002\b\u0005%\u00111\u0002\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0005\u0006S\u001e\u0001\r\u0001\u0019\u0005\b\u0003\u001b9\u0001\u0019AA\b\u0003%QwN\u0019*fgVdG\u000f\u0005\u0003\u0002\u0012\u0005MQ\"A<\n\u0007\u0005UqOA\u0005K_\n\u0014Vm];mi\u0006\u0019An\\4\u0015\u000f1\fY\"!\b\u0002 !)q\f\u0003a\u0001A\")\u0011\u000e\u0003a\u0001A\"9\u0011\u0011\u0005\u0005A\u0002\u0005\r\u0012a\u00047pO\u0016sGO]=SKF,Xm\u001d;\u0011\u0007%\u000b)#C\u0002\u0002(u\u0013q\u0002T8h\u000b:$(/\u001f*fcV,7\u000f^\u0001\u0012Kb,7-\u001e;f\t&\u0014Xm\u0019;jm\u0016\u001cHc\u00027\u0002.\u0005=\u0012\u0011\u0007\u0005\u0006?&\u0001\r\u0001\u0019\u0005\u0006S&\u0001\r\u0001\u0019\u0005\b\u0003gI\u0001\u0019AA\u001b\u0003)!\u0017N]3di&4Xm\u001d\t\u0007\u0003o\ty$!\u0012\u000f\t\u0005e\u0012Q\b\b\u0004!\u0006m\u0012\"A\u000f\n\u0005Yd\u0012\u0002BA!\u0003\u0007\u00121aU3r\u0015\t1H\u0004\u0005\u0003\u0002\u0012\u0005\u001d\u0013bAA%o\na!j\u001c2ESJ,7\r^5wK\u0006A1m\\7nC:$7\u000f\u0006\u0005\u0002P\u0005U\u0013qKA:!\rY\u0012\u0011K\u0005\u0004\u0003'b\"\u0001B+oSRDQa\u0018\u0006A\u0002ADq!!\u0017\u000b\u0001\u0004\tY&\u0001\u0003tS:\\\u0007\u0003BA/\u0003_j!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0004gN,'\u0002BA3\u0003O\n!A]:\u000b\t\u0005%\u00141N\u0001\u0003oNT!!!\u001c\u0002\u000f)\f7.\u0019:uC&!\u0011\u0011OA0\u00051\u00196/Z#wK:$8+\u001b8l\u0011\u001d\t\tG\u0003a\u0001\u0003k\u0002B!!\u0018\u0002x%!\u0011\u0011PA0\u0005\r\u00196/Z\u0001\u000fG>tg-\u001b:n\u0007>lW.\u00198e)\u0015a\u0017qPAA\u0011\u0015y6\u00021\u0001a\u0011\u0019\t\u0019i\u0003a\u0001A\u0006I1m\\7nC:$\u0017\nZ\u0001\u0007Q\u0016\fG\u000e\u001e5\u0015\r\u0005%\u0015\u0011SAJ!\u0011\tY)!$\u000f\u0005\u0005J\u0016bAAH;\nq\u0001*Z1mi\"\u0014Vm\u001d9p]N,\u0007\"B0\r\u0001\u0004\u0001\u0007\"B5\r\u0001\u0004\u0001\u0007f\u0001\u0001\u0002\u0018B!\u0011\u0011TAT\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015AC:uKJ,w\u000e^=qK*!\u0011\u0011UAR\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAAS\u0003\ry'oZ\u0005\u0005\u0003S\u000bYJ\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class JobRunnerResourceImpl
implements JobRunnerResource,
Logging {
    private final RunnerJobService runnerJobService;
    private final RunnerControlService runnerControlService;
    private final RunnerAvailabilityService runnerAvailabilityService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobRunnerResourceImpl jobRunnerResourceImpl = this;
        synchronized (jobRunnerResourceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerResource.JobReservationResponse reserveJob(String runnerId, String requestId) {
        this.logger().trace((Function0 & Serializable)() -> "Runner [" + runnerId + "] requested for a job with requestId [" + requestId + "]");
        Option possibleJobId = this.runnerJobService.reserveJob(runnerId);
        return new JobRunnerResource.JobReservationResponse(requestId, possibleJobId);
    }

    public JobRunnerResource.ConfirmationResponse confirmJob(String runnerId, String jobId, String requestId) {
        this.logger().trace((Function0 & Serializable)() -> "Runner [" + runnerId + "] request to confirm job " + jobId + " received with requestId [" + requestId + "]");
        boolean isConfirmed = this.runnerJobService.confirmJob(runnerId, jobId);
        return new JobRunnerResource.ConfirmationResponse(requestId, isConfirmed);
    }

    public JobRunnerResource.ConfirmationResponse finishJob(String runnerId, String requestId, JobResult jobResult) {
        this.logger().trace((Function0 & Serializable)() -> "Received result for jobId [" + jobResult.getJobIdentifier() + "] from runner [" + runnerId + "] with requestId [" + requestId + "]");
        this.runnerJobService.finishJob(jobResult);
        return new JobRunnerResource.ConfirmationResponse(requestId, true);
    }

    public JobRunnerResource.ConfirmationResponse log(String runnerId, String requestId, JobRunnerResource.LogEntryRequest logEntryRequest) {
        this.logger().trace((Function0 & Serializable)() -> "Received log entry [" + logEntryRequest + "] from runner [" + runnerId + "] with requestId [" + requestId + "]");
        LogEntry logEntry = new LogEntry(logEntryRequest.taskId(), logEntryRequest.executionId(), logEntryRequest.jobId(), logEntryRequest.chunk(), logEntryRequest.lastEntryTimestamp(), logEntryRequest.payload(), Option$.MODULE$.apply((Object)logEntryRequest.uriScheme()));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.runnerJobService.log(logEntry));
        if (try_ instanceof Success) {
            return new JobRunnerResource.ConfirmationResponse(requestId, true);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Error occurred while processing log entry [" + runnerId + "] with requestId [" + requestId + "] - sending back not-confirmed; error was: " + exception.getMessage());
            return new JobRunnerResource.ConfirmationResponse(requestId, false);
        }
        throw new MatchError((Object)try_);
    }

    public JobRunnerResource.ConfirmationResponse executeDirectives(String runnerId, String requestId, Seq<JobDirective> directives) {
        this.logger().trace((Function0 & Serializable)() -> "Received directives from runner [" + runnerId + "] with requestId [" + requestId + "]");
        this.runnerJobService.executeDirectives(directives);
        return new JobRunnerResource.ConfirmationResponse(requestId, true);
    }

    public void commands(String runnerId, SseEventSink sink, Sse sse) {
        this.logger().trace((Function0 & Serializable)() -> "Received request to open control channel for runnerId [" + runnerId + "]");
        this.runnerControlService.watch(runnerId, sink, sse);
    }

    public JobRunnerResource.ConfirmationResponse confirmCommand(String runnerId, String commandId) {
        this.logger().trace((Function0 & Serializable)() -> "Received confirmation for commandId [" + commandId + "] from runnerId [" + runnerId + "]");
        this.runnerControlService.confirmCommand(runnerId, commandId);
        return new JobRunnerResource.ConfirmationResponse(commandId, true);
    }

    public JobRunnerResource.HealthResponse health(String runnerId, String requestId) {
        Enumeration.Value value;
        this.logger().trace((Function0 & Serializable)() -> "Received request for health check from runnerId [" + runnerId + "] with requestId [" + requestId + "]");
        this.runnerControlService.alive(runnerId, System.currentTimeMillis());
        this.runnerAvailabilityService.alive(runnerId);
        ServerState.Mode mode = ServerState.getInstance().getCurrentMode();
        if (ServerState.Mode.STARTING.equals(mode)) {
            value = JobRunnerResource.ReleaseServerStates$.MODULE$.STARTING();
        } else if (ServerState.Mode.RUNNING.equals(mode)) {
            value = JobRunnerResource.ReleaseServerStates$.MODULE$.RUNNING();
        } else if (ServerState.Mode.MAINTENANCE.equals(mode)) {
            value = JobRunnerResource.ReleaseServerStates$.MODULE$.MAINTENANCE();
        } else {
            throw new MatchError((Object)mode);
        }
        Enumeration.Value serverState = value;
        return new JobRunnerResource.HealthResponse(requestId, serverState);
    }

    public JobRunnerResourceImpl(RunnerJobService runnerJobService, RunnerControlService runnerControlService, RunnerAvailabilityService runnerAvailabilityService) {
        this.runnerJobService = runnerJobService;
        this.runnerControlService = runnerControlService;
        this.runnerAvailabilityService = runnerAvailabilityService;
        Logging.$init$((Logging)this);
    }
}

