/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.runner.impl.ContainerExecutionResultEvent;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\b\u0010\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r\t\u0004\u0001\u0015!\u0003H\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0019y\u0007\u0001\"\u0011\u0002(!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\u0012qCU;o]\u0016\u00148k\u0019:jaR\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005A\t\u0012\u0001B5na2T!AE\n\u0002\rI,hN\\3s\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0005\u0001m\tS\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aD\u0005\u0003I=\u00111CU;o]\u0016\u00148k\u0019:jaR\u001cVM\u001d<jG\u0016\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003)\n\u0001b\u001a:jujdW\rZ\u0005\u0003Y\u001d\u0012q\u0001T8hO&tw-A\u0005yYJ\u001cuN\u001c4jOB\u0011qFM\u0007\u0002a)\u0011\u0011gE\u0001\u0007G>tg-[4\n\u0005M\u0002$!\u0003-me\u000e{gNZ5h\u0003AQwN\u0019*v]:,'oU3sm&\u001cW\r\u0005\u0002#m%\u0011qg\u0004\u0002\u0011\u0015>\u0014'+\u001e8oKJ\u001cVM\u001d<jG\u0016\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005ijT\"A\u001e\u000b\u0005q\u001a\u0012aB:feZL7-Z\u0005\u0003}m\u0012\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011\t%i\u0011#\u0011\u0005\t\u0002\u0001\"B\u0017\u0005\u0001\u0004q\u0003\"\u0002\u001b\u0005\u0001\u0004)\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0014\u0001\u0005:fgB|gn]3Qe>l\u0017n]3t+\u00059\u0005\u0003\u0002%N\u001fjk\u0011!\u0013\u0006\u0003\u0015.\u000b!bY8oGV\u0014(/\u001a8u\u0015\taU$\u0001\u0006d_2dWm\u0019;j_:L!AT%\u0003\u000fQ\u0013\u0018.Z'baB\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\u000f\u000e\u0003MS!\u0001V\r\u0002\rq\u0012xn\u001c;?\u0013\t1V$\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u001e!\rYVlX\u0007\u00029*\u0011!*H\u0005\u0003=r\u0013q\u0001\u0015:p[&\u001cX\r\u0005\u0002#A&\u0011\u0011m\u0004\u0002\u001e\u0007>tG/Y5oKJ,\u00050Z2vi&|gNU3tk2$XI^3oi\u0006\t\"/Z:q_:\u001cX\r\u0015:p[&\u001cXm\u001d\u0011\u0002\u0019=\u0014'.Z2u\u001b\u0006\u0004\b/\u001a:\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0011\u0011\fG/\u00192j]\u0012T!A[6\u0002\u000f)\f7m[:p]*\u0011AnF\u0001\nM\u0006\u001cH/\u001a:y[2L!A\\4\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u001b\u0015DXmY;uKN\u001b'/\u001b9u+\t\tH\u000fF\u0003s{~\f\u0019\u0002\u0005\u0002ti2\u0001A!B;\t\u0005\u00041(!\u0001+\u0012\u0005]T\bC\u0001\u000fy\u0013\tIXDA\u0004O_RD\u0017N\\4\u0011\u0005qY\u0018B\u0001?\u001e\u0005\r\te.\u001f\u0005\u0006}\"\u0001\raT\u0001\u0007g\u000e\u0014\u0018\u000e\u001d;\t\u000f\u0005\u0005\u0001\u00021\u0001\u0002\u0004\u0005y\u0011N\u001c9viB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0004\u0002\u0006\u0005=qjG\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!Q\u000f^5m\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u000f\u00111!T1q\u0011\u001d\t)\u0002\u0003a\u0001\u0003/\tQ\u0002^=qKJ+g-\u001a:f]\u000e,\u0007#BA\r\u0003G\u0011XBAA\u000e\u0015\u0011\ti\"a\b\u0002\tQL\b/\u001a\u0006\u0004\u0003CI\u0017\u0001B2pe\u0016LA!!\n\u0002\u001c\tiA+\u001f9f%\u00164WM]3oG\u0016,B!!\u000b\u0002@Q1\u00111FA!\u0003\u0007\u0002b!!\f\u00028\u0005ub\u0002BA\u0018\u0003gq1AUA\u0019\u0013\u0005q\u0012bAA\u001b;\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u0011aAV3di>\u0014(bAA\u001b;A\u00191/a\u0010\u0005\u000bUL!\u0019\u0001<\t\u000byL\u0001\u0019A(\t\u000f\u0005\u0005\u0011\u00021\u0001\u0002\u0004\u00051R\r_3dkR,7k\u0019:jaR4uN](cU\u0016\u001cG/\u0006\u0003\u0002J\u00055CCBA&\u0003\u001f\n\t\u0006E\u0002t\u0003\u001b\"Q!\u001e\u0006C\u0002YDQA \u0006A\u0002=Cq!!\u0001\u000b\u0001\u0004\t\u0019!\u0001\nfq\u0016\u001cW\u000f^3P]\u000e{g\u000e^1j]\u0016\u0014H#B0\u0002X\u0005e\u0003\"\u0002@\f\u0001\u0004y\u0005bBA\u0001\u0017\u0001\u0007\u00111A\u0001\u000fg\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^3e)\u0019\ty&!\u001a\u0002jA\u0019A$!\u0019\n\u0007\u0005\rTD\u0001\u0003V]&$\bBBA4\u0019\u0001\u0007q*A\ttGJL\u0007\u000f^#yK\u000e,H/[8o\u0013\u0012Dq!a\u001b\r\u0001\u0004\t\u0019!A\u0004qCfdw.\u00193\u0002?=t7i\u001c8uC&tWM]#yK\u000e,H/[8o%\u0016\u001cX\u000f\u001c;Fm\u0016tG\u000f\u0006\u0003\u0002`\u0005E\u0004BBA:\u001b\u0001\u0007q,\u0001\u0005sKN\u0004xN\\:fQ\ri\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\n\u0002\r\u00154XM\u001c;t\u0013\u0011\t\t)a\u001f\u0003\u001d\u0005\u001b\u0018P\\2Tk\n\u001c8M]5cK\"\u001a\u0001!!\"\u0011\t\u0005\u001d\u0015QS\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u0005=\u0015\u0011S\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111S\u0001\u0004_J<\u0017\u0002BAL\u0003\u0013\u0013qaU3sm&\u001cW\rK\u0002\u0001\u00037\u0003B!!\u001f\u0002\u001e&!\u0011qTA>\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\u0002")
public class RunnerScriptServiceImpl
implements RunnerScriptService,
Logging {
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private final BroadcastService broadcastService;
    private final TrieMap<String, Promise<ContainerExecutionResultEvent>> responsePromises;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private TrieMap<String, Promise<ContainerExecutionResultEvent>> responsePromises() {
        return this.responsePromises;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    @Override
    public <T> T executeScript(String script, Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + error);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> Vector<T> executeScript(String script, Map<String, Object> inputParameters) {
        Some some;
        Object commandResponse;
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some && (commandResponse = (some = (Some)option).value()) instanceof List) {
            List list = (List)commandResponse;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)resultItem -> {
                String nodeString = this.objectMapper().writeValueAsString(resultItem);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object result = success.value();
                    this.logger().debug((Function0 & Serializable)() -> "Container script " + script + " executed successfully");
                    return result;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
                }
                throw new MatchError((Object)try_);
            })).toVector();
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + error);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> T executeScriptForObject(String script, Map<String, Object> inputParameters) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeOnContainer(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            String nodeString = this.objectMapper().writeValueAsString(commandResponse);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                this.logger().debug((Function0 & Serializable)() -> "Container script " + script + " executed successfully");
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            this.logger().warn((Function0 & Serializable)() -> "Container script " + script + " failed with error: " + scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey()));
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        this.logger().error((Function0 & Serializable)() -> "Failed to process container script " + script + " result");
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ContainerExecutionResultEvent executeOnContainer(String script, Map<String, Object> inputParameters) {
        ContainerExecutionResultEvent containerExecutionResultEvent;
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "Cannot find active remote runner for executing script '" + script + "'");
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        String scriptExecutionId = runner2.execute((RemoteExecution)scriptTask);
        Promise responsePromise = Promise$.MODULE$.apply();
        this.responsePromises().put((Object)scriptExecutionId, (Object)responsePromise);
        try {
            containerExecutionResultEvent = (ContainerExecutionResultEvent)Await$.MODULE$.result((Awaitable)responsePromise.future(), (Duration)this.xlrConfig.timeouts().releaseActionResponse());
        }
        catch (TimeoutException e) {
            this.logger().error((Function0 & Serializable)() -> "Execution of script '" + script + "' timed out");
            throw new ContainerScriptException("Execution of script '" + script + "' timed out: " + e.getMessage());
        }
        return containerExecutionResultEvent;
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, Map<String, Object> payload) {
        ContainerExecutionResultEvent response = new ContainerExecutionResultEvent(scriptExecutionId, payload);
        this.logger().debug((Function0 & Serializable)() -> "Sending execution response for " + scriptExecutionId);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)response, true);
    }

    @AsyncSubscribe
    public void onContainerExecutionResultEvent(ContainerExecutionResultEvent response) {
        this.logger().debug((Function0 & Serializable)() -> "Received execution response for " + response.scriptExecutionId());
        this.responsePromises().get((Object)response.scriptExecutionId()).foreach((Function1 & Serializable)promise -> {
            Promise promise2;
            try {
                try {
                    promise2 = promise.success((Object)response);
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Failed to complete promise for " + response.scriptExecutionId() + ": " + e.getMessage());
                    promise2 = BoxedUnit.UNIT;
                }
            }
            finally {
                this.responsePromises().remove((Object)response.scriptExecutionId());
            }
            return promise2;
        });
    }

    public RunnerScriptServiceImpl(XlrConfig xlrConfig, JobRunnerService jobRunnerService, BroadcastService broadcastService) {
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
        this.responsePromises = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

