package com.xebialabs.xlrelease.runner.impl.spring

import com.typesafe.config.Config
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ManagedActor}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor.{RunnerHealth, RunnerProxyCommand, actorName}
import com.xebialabs.xlrelease.runner.impl.spring.RemoteJobRunnerConfiguration.RunnerProxyActorHolder
import com.xebialabs.xlrelease.runner.impl.{RemoteJobRunnerOps, RunnerProxyActor, RunnerProxyActorSupervisor}
import org.apache.pekko.cluster.sharding.ShardRegion
import org.springframework.context.annotation.{Bean, Configuration}

object RemoteJobRunnerConfiguration {
  type RunnerProxyActorHolder = ManagedActor[RunnerProxyActor]
}
@Configuration
class RemoteJobRunnerConfiguration(xlrConfig: XlrConfig, actorSystemHolder: ActorSystemHolder) {
  @Bean
  def remoteJobRunnerOps: RemoteJobRunnerOps = RemoteJobRunnerOps

  @Bean
  def runnerProxyActorHolder: RunnerProxyActorHolder = {
    if (xlrConfig.isClusterEnabled) {
      val jobRunnerShardingConfig: Config = xlrConfig.xl.getConfig("job-runner.pekko.cluster.sharding")
      val extractEntityId: ShardRegion.ExtractEntityId = {
        case health: RunnerHealth => (actorName(health.runnerId), health)
        case cmd: RunnerProxyCommand => (actorName(cmd.runnerId), cmd)
      }
      val extractShardId: ShardRegion.ExtractShardId = {
        case health: RunnerHealth => actorName(health.runnerId).shardId()
        case cmd: RunnerProxyCommand => actorName(cmd.runnerId).shardId()
        case ShardRegion.StartEntity(entityId) => entityId.shardId()
      }

      actorSystemHolder.shardedActorOf[RunnerProxyActor](
        classOf[RunnerProxyActor],
        RunnerProxyActor.SHARDING_TYPE_NAME,
        extractEntityId,
        extractShardId,
        Some(jobRunnerShardingConfig)
      )
    } else {
      actorSystemHolder.actorOf[RunnerProxyActor](classOf[RunnerProxyActorSupervisor], "runner-proxy-supervisor")
    }
  }
}
