/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenCreatedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenDeletedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenUpdatedEvent;
import com.xebialabs.xlrelease.runner.repository.RunnerTokenRepository;
import com.xebialabs.xlrelease.runner.repository.data.RunnerTokenRow;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@CacheConfig(cacheManager="runnerCacheManager")
@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u0005\u000b\u0001UA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)q\u0007\u0001C\u0001q!)Q\b\u0001C!}!)!\u000f\u0001C!g\")\u0011\u0010\u0001C!u\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA5\u0001\u0011\u0005\u00111\u000e\u0002\u0017%Vtg.\u001a:U_.,gnU3sm&\u001cW-S7qY*\u00111\u0002D\u0001\u0005S6\u0004HN\u0003\u0002\u000e\u001d\u00051!/\u001e8oKJT!a\u0004\t\u0002\u0013ad'/\u001a7fCN,'BA\t\u0013\u0003%AXMY5bY\u0006\u00147OC\u0001\u0014\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0003\b\u0012\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\u0002%D\u0001\u001f\u0015\tyB\"A\u0004tKJ4\u0018nY3\n\u0005\u0005r\"A\u0005*v]:,'\u000fV8lK:\u001cVM\u001d<jG\u0016\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n\u0001b\u001a:jujdW\rZ\u0005\u0003S\u0011\u0012q\u0001T8hO&tw-\u0001\tce>\fGmY1tiN+'O^5dKB\u0011AFL\u0007\u0002[)\u0011qDD\u0005\u0003_5\u0012\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002+I,hN\\3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ssB\u0011!'N\u0007\u0002g)\u0011A\u0007D\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001c4\u0005U\u0011VO\u001c8feR{7.\u001a8SKB|7/\u001b;pef\fa\u0001P5oSRtDcA\u001d<yA\u0011!\bA\u0007\u0002\u0015!)!f\u0001a\u0001W!)\u0001g\u0001a\u0001c\u0005I2M]3bi\u0016|%/\u00169eCR,'+\u001e8oKJ$vn[3o)\ryTi\u0017\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u00052\ta\u0001Z8nC&t\u0017B\u0001#B\u0005-\u0011VO\u001c8feR{7.\u001a8\t\u000b\u0019#\u0001\u0019A$\u0002\u0011I,hN\\3s\u0013\u0012\u0004\"\u0001\u0013-\u000f\u0005%3fB\u0001&V\u001d\tYEK\u0004\u0002M':\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!R\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0005E\u0011\u0012BA\b\u0011\u0013\tia\"\u0003\u0002C\u0019%\u0011q+Q\u0001\ba\u0006\u001c7.Y4f\u0013\tI&L\u0001\u0005Sk:tWM]%e\u0015\t9\u0016\tC\u0003]\t\u0001\u0007Q,\u0001\u0006fqBL'/\u001f#bi\u0016\u0004\"AX2\u000e\u0003}S!\u0001Y1\u0002\tU$\u0018\u000e\u001c\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0003ECR,\u0007F\u0001\u0003g!\t9\u0007/D\u0001i\u0015\tI'.\u0001\u0006b]:|G/\u0019;j_:T!a\u001b7\u0002\t\r|'/\u001a\u0006\u0003[:\f!\"\\5de>lW\r^3s\u0015\u0005y\u0017AA5p\u0013\t\t\bNA\u0003US6,G-A\teK2,G/\u001a*v]:,'\u000fV8lK:$\"\u0001^<\u0011\u0005])\u0018B\u0001<\u0019\u0005\u0011)f.\u001b;\t\u000b\u0019+\u0001\u0019A$)\u0005\u00151\u0017a\u00034j]\u0012\u0014\u0015\u0010V8lK:$2a_A\u0005!\r9BP`\u0005\u0003{b\u0011aa\u00149uS>t\u0007cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007\u0019\u0014\u0001\u00023bi\u0006LA!a\u0002\u0002\u0002\tq!+\u001e8oKJ$vn[3o%><\bbBA\u0006\r\u0001\u0007\u0011QB\u0001\ni>\\WM\u001c%bg\"\u0004B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\tq\u0005$C\u0002\u0002\u0016a\ta\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b1!\u0012aA\u001a\u0015\b\r\u0005\u0005\u0012qGA\u001d!\u0011\t\u0019#a\r\u000e\u0005\u0005\u0015\"bA5\u0002()!\u0011\u0011FA\u0016\u0003\u0015\u0019\u0017m\u00195f\u0015\u0011\ti#a\f\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\r\u0002\u0007=\u0014x-\u0003\u0003\u00026\u0005\u0015\"!C\"bG\",\u0017M\u00197f\u0003)\u0019\u0017m\u00195f\u001d\u0006lWm\u001d\u0017\u0003\u0003w\t#!!\u0010\u0002\u0019I,hN\\3s[Q|7.\u001a8\u0002%=t'+\u001e8oKJ$vn[3o\u000bZ,g\u000e\u001e\u000b\u0004i\u0006\r\u0003bBA#\u000f\u0001\u0007\u0011qI\u0001\u0011eVtg.\u001a:U_.,g.\u0012<f]R\u00042AOA%\u0013\r\tYE\u0003\u0002\u0011%Vtg.\u001a:U_.,g.\u0012<f]RD3aBA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+\u001d\u00051QM^3oiNLA!!\u0017\u0002T\tI1+\u001e2tGJL'-\u001a\u0015\f\u000f\u0005u\u0013qGA2\u0003K\n9\u0007\u0005\u0003\u0002$\u0005}\u0013\u0002BA1\u0003K\u0011!bQ1dQ\u0016,e/[2uY\t\tY$\u0001\u0006bY2,e\u000e\u001e:jKNL\u0012!A\u0001\u0013_:TuN\u0019*v]:,'\u000fR3mKR,G\rF\u0002u\u0003[Bq!a\u001c\t\u0001\u0004\t\t(A\u0003fm\u0016tG\u000f\u0005\u0003\u0002t\u0005eTBAA;\u0015\u0011\t)&a\u001e\u000b\u0005\ts\u0011\u0002BA>\u0003k\u0012\u0011dQ8oM&<WO]1uS>tG)\u001a7fi\u0016$WI^3oi\"\u001a\u0001\"a\u0014)\u0007\u0001\t\t\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\u0011\t9)a\u000b\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\f\u0006\u0015%aB*feZL7-\u001a\u0015\u0004\u0001\u0005=\u0005\u0003BA)\u0003#KA!a%\u0002T\tiQI^3oi2K7\u000f^3oKJDs\u0001AAL\u0003;\u000by\n\u0005\u0003\u0002$\u0005e\u0015\u0002BAN\u0003K\u00111bQ1dQ\u0016\u001cuN\u001c4jO\u0006a1-Y2iK6\u000bg.Y4fe\u0006\u0012\u0011\u0011U\u0001\u0013eVtg.\u001a:DC\u000eDW-T1oC\u001e,'\u000f")
public class RunnerTokenServiceImpl
implements RunnerTokenService,
Logging {
    private final BroadcastService broadcastService;
    private final RunnerTokenRepository runnerTokenRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerTokenServiceImpl runnerTokenServiceImpl = this;
        synchronized (runnerTokenServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public RunnerToken createOrUpdateRunnerToken(String runnerId, Date expiryDate) {
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RRA());
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        if (this.runnerTokenRepository.exists(runnerId)) {
            this.runnerTokenRepository.update(runnerId, tokenHash, expiryDate);
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenUpdatedEvent(runnerId), true);
        } else {
            this.runnerTokenRepository.create(runnerId, tokenHash, expiryDate);
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenCreatedEvent(runnerId), true);
        }
        return new RunnerToken(runnerId, token);
    }

    @Timed
    public void deleteRunnerToken(String runnerId) {
        this.runnerTokenRepository.delete(runnerId);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenDeletedEvent(runnerId), true);
    }

    @Timed
    @Cacheable(cacheNames={"runner-token"})
    public Option<RunnerTokenRow> findByToken(String tokenHash) {
        return this.runnerTokenRepository.findByToken(tokenHash);
    }

    @Subscribe
    @CacheEvict(cacheNames={"runner-token"}, allEntries=true)
    public void onRunnerTokenEvent(RunnerTokenEvent runnerTokenEvent) {
        this.logger().debug((Function0 & Serializable)() -> "Invalidating runner token cache");
    }

    @Subscribe
    public void onJobRunnerDeleted(ConfigurationDeletedEvent event) {
        BaseConfiguration config = event.conf();
        BaseConfiguration baseConfiguration = config;
        if (baseConfiguration instanceof RemoteJobRunner) {
            RemoteJobRunner remoteJobRunner = (RemoteJobRunner)baseConfiguration;
            this.logger().trace((Function0 & Serializable)() -> "Deleting all tokens associated with runner [" + remoteJobRunner.getId() + "]");
            this.deleteRunnerToken(remoteJobRunner.getId());
            return;
        }
    }

    public RunnerTokenServiceImpl(BroadcastService broadcastService, RunnerTokenRepository runnerTokenRepository) {
        this.broadcastService = broadcastService;
        this.runnerTokenRepository = runnerTokenRepository;
        Logging.$init$((Logging)this);
    }
}

