import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import './remote-runners-placeholder.component.less';

export interface RemoteRunnersPlaceholderProps {
    onViewChange: () => void;
}

export const RemoteRunnersPlaceholder = ({ onViewChange }: RemoteRunnersPlaceholderProps) => {
    return (
        <div className="remote-runners-placeholder">
            <div className="remote-runners">
                <img alt="Digital.ai Release runners" src={`static/@project.version@/include/remote-runners/assets/remote-runners.svg`} width="300" />
                <div className="remote-runners-title">Digital.ai Release runner overview</div>
                <div className="remote-runners-description">
                    Digital.ai Release runners handle Release task execution on remote servers. There are currently no Runners configured.
                    <div className="remote-runners-buttons">
                        <DotButton className="remote-runners-create-btn" data-testid="create-btn" onClick={onViewChange} type="primary">
                            Install Runner
                        </DotButton>
                    </div>
                </div>
            </div>
        </div>
    );
};
