/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.actors.ManagedActor;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotely;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyActor;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyResponse;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0007\u000e\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003D\u0001\u0011\u0005A\tC\u0003J\u0001\u0011%!\nC\u0003V\u0001\u0011%a\u000bC\u0003s\u0001\u0011\u00053\u000f\u0003\u0004s\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u001a\u0001\t\u0003\n9GA\fSk:tWM]*de&\u0004HoU3sm&\u001cW-S7qY*\u0011abD\u0001\u0005S6\u0004HN\u0003\u0002\u0011#\u00051!/\u001e8oKJT!AE\n\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"A\u0007\n\u0005\tj!a\u0005*v]:,'oU2sSB$8+\u001a:wS\u000e,\u0017AG3yK\u000e,H/\u001a*f[>$X\r\\=BGR|'\u000fS8mI\u0016\u0014\bCA\u00136\u001d\t13G\u0004\u0002(e9\u0011\u0001&\r\b\u0003SAr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055:\u0012A\u0002\u001fs_>$h(C\u0001\u0017\u0013\t!R#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003\u001d=I!\u0001N\u0007\u0002?\u0015CXmY;uKJ+Wn\u001c;fYf\f5\r^8s\u0013:LG/[1mSj,'/\u0003\u00027o\tQR\t_3dkR,'+Z7pi\u0016d\u00170Q2u_JDu\u000e\u001c3fe*\u0011A'D\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"AO\u001f\u000e\u0003mR!\u0001P\t\u0002\r\r|gNZ5h\u0013\tq4HA\u0005YYJ\u001cuN\u001c4jO\u0006\u0001\"n\u001c2Sk:tWM]*feZL7-\u001a\t\u0003A\u0005K!AQ\u0007\u0003!){'MU;o]\u0016\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003F\r\u001eC\u0005C\u0001\u0011\u0001\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015AD\u00011\u0001:\u0011\u0015yD\u00011\u0001A\u00031y'M[3di6\u000b\u0007\u000f]3s+\u0005Y\u0005C\u0001'T\u001b\u0005i%B\u0001(P\u0003!!\u0017\r^1cS:$'B\u0001)R\u0003\u001dQ\u0017mY6t_:T!AU\u000b\u0002\u0013\u0019\f7\u000f^3sq6d\u0017B\u0001+N\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003-\t7o[!oI\u0006;\u0018-\u001b;\u0016\u0005]SFc\u0001-dYB\u0011\u0011L\u0017\u0007\u0001\t\u0015YfA1\u0001]\u0005\u0005!\u0016CA/a!\tQb,\u0003\u0002`7\t9aj\u001c;iS:<\u0007C\u0001\u000eb\u0013\t\u00117DA\u0002B]fDQ\u0001\u001a\u0004A\u0002\u0015\f\u0011B[8c%Vtg.\u001a:\u0011\u0005\u0019TW\"A4\u000b\u0005AA'BA5\u0012\u0003\u0019!w.\\1j]&\u00111n\u001a\u0002\n\u0015>\u0014'+\u001e8oKJDQ!\u001c\u0004A\u00029\fqB]3n_R,W\t_3dkRLwN\u001c\t\u0003_Bl\u0011\u0001[\u0005\u0003c\"\u0014qBU3n_R,W\t_3dkRLwN\\\u0001\u000eKb,7-\u001e;f'\u000e\u0014\u0018\u000e\u001d;\u0016\u0005Q4HCB;x\u0003\u0007\t9\u0002\u0005\u0002Zm\u0012)1l\u0002b\u00019\")\u0001p\u0002a\u0001s\u000611o\u0019:jaR\u0004\"A\u001f@\u000f\u0005md\bCA\u0016\u001c\u0013\ti8$\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~7!9\u0011QA\u0004A\u0002\u0005\u001d\u0011aD5oaV$\b+\u0019:b[\u0016$XM]:\u0011\r\u0005%\u00111C=\u001a\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001B;uS2T!!!\u0005\u0002\t)\fg/Y\u0005\u0005\u0003+\tYAA\u0002NCBDq!!\u0007\b\u0001\u0004\tY\"A\u0007usB,'+\u001a4fe\u0016t7-\u001a\t\u0006\u0003;\t9#^\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A/\u001f9f\u0015\r\t)cT\u0001\u0005G>\u0014X-\u0003\u0003\u0002*\u0005}!!\u0004+za\u0016\u0014VMZ3sK:\u001cW-\u0006\u0003\u0002.\u0005\rCCBA\u0018\u0003\u000b\n9\u0005\u0005\u0004\u00022\u0005m\u0012\u0011\t\b\u0005\u0003g\t9DD\u0002,\u0003kI\u0011\u0001H\u0005\u0004\u0003sY\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003{\tyD\u0001\u0004WK\u000e$xN\u001d\u0006\u0004\u0003sY\u0002cA-\u0002D\u0011)1\f\u0003b\u00019\")\u0001\u0010\u0003a\u0001s\"9\u0011Q\u0001\u0005A\u0002\u0005\u001d\u0011AF3yK\u000e,H/Z*de&\u0004HOR8s\u001f\nTWm\u0019;\u0016\t\u00055\u0013\u0011\u000b\u000b\u0007\u0003\u001f\n\u0019&!\u0016\u0011\u0007e\u000b\t\u0006B\u0003\\\u0013\t\u0007A\fC\u0003y\u0013\u0001\u0007\u0011\u0010C\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\u001f\u0015DXmY;uKJ+Wn\u001c;fYf$b!a\u0017\u0002b\u0005\r\u0004c\u0001\u0011\u0002^%\u0019\u0011qL\u0007\u0003/\u0015CXmY;uKJ+Wn\u001c;fYf\u0014Vm\u001d9p]N,\u0007\"\u0002=\u000b\u0001\u0004I\bbBA\u0003\u0015\u0001\u0007\u0011qA\u0001\u000fg\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^3e)\u0019\tI'a\u001c\u0002tA\u0019!$a\u001b\n\u0007\u000554D\u0001\u0003V]&$\bBBA9\u0017\u0001\u0007\u00110A\ttGJL\u0007\u000f^#yK\u000e,H/[8o\u0013\u0012Dq!!\u001e\f\u0001\u0004\t9!A\u0004qCfdw.\u00193)\u0007\u0001\tI\b\u0005\u0003\u0002|\u0005%UBAA?\u0015\u0011\ty(!!\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002\u0004\u0006\u0015\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005\u001d\u0015aA8sO&!\u00111RA?\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RunnerScriptServiceImpl
implements RunnerScriptService {
    private final ManagedActor<ExecuteRemotelyActor> executeRemotelyActorHolder;
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private <T> T askAndAwait(JobRunner jobRunner, RemoteExecution remoteExecution) {
        Object object;
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActionResponse());
        try {
            ExecuteRemotely x$1 = new ExecuteRemotely(jobRunner, remoteExecution);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = this.executeRemotelyActorHolder.$qmark$default$3((Object)x$1);
            object = Await$.MODULE$.result((Awaitable)this.executeRemotelyActorHolder.$qmark((Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }
        catch (Exception e) {
            throw new ContainerScriptException(e.getMessage());
        }
        return (T)object;
    }

    @Override
    public <T> T executeScript(String script, Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> Vector<T> executeScript(String script, Map<String, Object> inputParameters) {
        Some some;
        Object commandResponse;
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some && (commandResponse = (some = (Some)option).value()) instanceof List) {
            List list = (List)commandResponse;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)resultItem -> {
                String nodeString = this.objectMapper().writeValueAsString(resultItem);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object result = success.value();
                    return result;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
                }
                throw new MatchError((Object)try_);
            })).toVector();
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> T executeScriptForObject(String script, Map<String, Object> inputParameters) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            String nodeString = this.objectMapper().writeValueAsString(commandResponse);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ExecuteRemotelyResponse executeRemotely(String script, Map<String, Object> inputParameters) {
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        return (ExecuteRemotelyResponse)this.askAndAwait(runner2, (RemoteExecution)scriptTask);
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, Map<String, Object> payload) {
        ExecuteRemotelyResponse x$1 = new ExecuteRemotelyResponse(scriptExecutionId, payload);
        ActorRef x$2 = this.executeRemotelyActorHolder.$bang$default$2((Object)x$1);
        this.executeRemotelyActorHolder.$bang((Object)x$1, x$2);
    }

    public RunnerScriptServiceImpl(ManagedActor<ExecuteRemotelyActor> executeRemotelyActorHolder, XlrConfig xlrConfig, JobRunnerService jobRunnerService) {
        this.executeRemotelyActorHolder = executeRemotelyActorHolder;
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
    }
}

