/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotely;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyActorHolder;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyResponse;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u0007\u000f\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00034\u0001\u0011\u0005A\u0007\u0003\u0005:\u0001!\u0015\r\u0011\"\u0003;\u0011\u00159\u0005\u0001\"\u0003I\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0019\u0001\b\u0001\"\u0011\u0002.!9\u00111\n\u0001\u0005B\u00055\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003O\u0002A\u0011IA5\u0005]\u0011VO\u001c8feN\u001b'/\u001b9u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u0010!\u0005!\u0011.\u001c9m\u0015\t\t\"#\u0001\u0004sk:tWM\u001d\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0012\u000e\u00039I!a\t\b\u0003'I+hN\\3s'\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\u00025\u0015DXmY;uKJ+Wn\u001c;fYf\f5\r^8s\u0011>dG-\u001a:\u0011\u0005\u00052\u0013BA\u0014\u000f\u0005i)\u00050Z2vi\u0016\u0014V-\\8uK2L\u0018i\u0019;pe\"{G\u000eZ3s\u0003%AHN]\"p]\u001aLw\r\u0005\u0002+[5\t1F\u0003\u0002-%\u000511m\u001c8gS\u001eL!AL\u0016\u0003\u0013ac'oQ8oM&<\u0017\u0001\u00056pEJ+hN\\3s'\u0016\u0014h/[2f!\t\t\u0013'\u0003\u00023\u001d\t\u0001\"j\u001c2Sk:tWM]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU2t\u0007\u000f\t\u0003C\u0001AQ\u0001\n\u0003A\u0002\u0015BQ\u0001\u000b\u0003A\u0002%BQa\f\u0003A\u0002A\n\u0001\"Y2u_J\u0014VMZ\u000b\u0002wA\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0001\u0006\u000bQ\u0001]3lW>T!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\t\u0003\u000e$xN\u001d*fM\u0006aqN\u00196fGRl\u0015\r\u001d9feV\t\u0011\n\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006AA-\u0019;bE&tGM\u0003\u0002O\u001f\u00069!.Y2lg>t'B\u0001)\u0017\u0003%1\u0017m\u001d;feblG.\u0003\u0002S\u0017\naqJ\u00196fGRl\u0015\r\u001d9fe\u0006Y\u0011m]6B]\u0012\fu/Y5u+\t)\u0006\fF\u0002WC*\u0004\"a\u0016-\r\u0001\u0011)\u0011l\u0002b\u00015\n\tA+\u0005\u0002\\=B\u00111\u0004X\u0005\u0003;r\u0011qAT8uQ&tw\r\u0005\u0002\u001c?&\u0011\u0001\r\b\u0002\u0004\u0003:L\b\"\u00022\b\u0001\u0004\u0019\u0017!\u00036pEJ+hN\\3s!\t!\u0007.D\u0001f\u0015\t\tbM\u0003\u0002h%\u00051Am\\7bS:L!![3\u0003\u0013){'MU;o]\u0016\u0014\b\"B6\b\u0001\u0004a\u0017a\u0004:f[>$X-\u0012=fGV$\u0018n\u001c8\u0011\u00055tW\"\u00014\n\u0005=4'a\u0004*f[>$X-\u0012=fGV$\u0018n\u001c8\u0002\u001b\u0015DXmY;uKN\u001b'/\u001b9u+\t\u0011H\u000f\u0006\u0004tk\u0006\u0015\u0011\u0011\u0004\t\u0003/R$Q!\u0017\u0005C\u0002iCQA\u001e\u0005A\u0002]\faa]2sSB$\bC\u0001=\u0000\u001d\tIX\u0010\u0005\u0002{95\t1P\u0003\u0002}1\u00051AH]8pizJ!A \u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tqH\u0004C\u0004\u0002\b!\u0001\r!!\u0003\u0002\u001f%t\u0007/\u001e;QCJ\fW.\u001a;feN\u0004b!a\u0003\u0002\u0016]TRBAA\u0007\u0015\u0011\ty!!\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005\ri\u0015\r\u001d\u0005\b\u00037A\u0001\u0019AA\u000f\u00035!\u0018\u0010]3SK\u001a,'/\u001a8dKB)\u0011qDA\u0015g6\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003usB,'bAA\u0014\u001b\u0006!1m\u001c:f\u0013\u0011\tY#!\t\u0003\u001bQK\b/\u001a*fM\u0016\u0014XM\\2f+\u0011\ty#!\u0012\u0015\r\u0005E\u0012qIA%!\u0019\t\u0019$!\u0010\u0002D9!\u0011QGA\u001d\u001d\rQ\u0018qG\u0005\u0002;%\u0019\u00111\b\u000f\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\u00191Vm\u0019;pe*\u0019\u00111\b\u000f\u0011\u0007]\u000b)\u0005B\u0003Z\u0013\t\u0007!\fC\u0003w\u0013\u0001\u0007q\u000fC\u0004\u0002\b%\u0001\r!!\u0003\u0002-\u0015DXmY;uKN\u001b'/\u001b9u\r>\u0014xJ\u00196fGR,B!a\u0014\u0002TQ1\u0011\u0011KA+\u0003/\u00022aVA*\t\u0015I&B1\u0001[\u0011\u00151(\u00021\u0001x\u0011\u001d\t9A\u0003a\u0001\u0003\u0013\tq\"\u001a=fGV$XMU3n_R,G.\u001f\u000b\u0007\u0003;\n\u0019'!\u001a\u0011\u0007\u0005\ny&C\u0002\u0002b9\u0011q#\u0012=fGV$XMU3n_R,G.\u001f*fgB|gn]3\t\u000bY\\\u0001\u0019A<\t\u000f\u0005\u001d1\u00021\u0001\u0002\n\u0005q1o\u0019:jaR,\u00050Z2vi\u0016$GCBA6\u0003c\n)\bE\u0002\u001c\u0003[J1!a\u001c\u001d\u0005\u0011)f.\u001b;\t\r\u0005MD\u00021\u0001x\u0003E\u00198M]5qi\u0016CXmY;uS>t\u0017\n\u001a\u0005\b\u0003ob\u0001\u0019AA\u0005\u0003\u001d\u0001\u0018-\u001f7pC\u0012D3\u0001AA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b!b\u001d;fe\u0016|G/\u001f9f\u0015\r\t)iQ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011\u0011RA@\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RunnerScriptServiceImpl
implements RunnerScriptService {
    private ActorRef actorRef;
    private ExecuteRemotelyActorHolder executeRemotelyActorHolder;
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private volatile boolean bitmap$0;

    private ActorRef actorRef$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$0) {
                this.actorRef = this.executeRemotelyActorHolder.actorRef();
                this.bitmap$0 = true;
            }
        }
        this.executeRemotelyActorHolder = null;
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private <T> T askAndAwait(JobRunner jobRunner, RemoteExecution remoteExecution) {
        Object object;
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActionResponse());
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.actorRef());
            ExecuteRemotely x$1 = new ExecuteRemotely(jobRunner, remoteExecution);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }
        catch (Exception e) {
            throw new ContainerScriptException(e.getMessage());
        }
        return (T)object;
    }

    @Override
    public <T> T executeScript(String script, Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> Vector<T> executeScript(String script, Map<String, Object> inputParameters) {
        Some some;
        Object commandResponse;
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some && (commandResponse = (some = (Some)option).value()) instanceof List) {
            List list = (List)commandResponse;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)resultItem -> {
                String nodeString = this.objectMapper().writeValueAsString(resultItem);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object result = success.value();
                    return result;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
                }
                throw new MatchError((Object)try_);
            })).toVector();
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> T executeScriptForObject(String script, Map<String, Object> inputParameters) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            String nodeString = this.objectMapper().writeValueAsString(commandResponse);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ExecuteRemotelyResponse executeRemotely(String script, Map<String, Object> inputParameters) {
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        return (ExecuteRemotelyResponse)this.askAndAwait(runner2, (RemoteExecution)scriptTask);
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, Map<String, Object> payload) {
        ExecuteRemotelyResponse x$1 = new ExecuteRemotelyResponse(scriptExecutionId, payload);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
        this.actorRef().$bang((Object)x$1, x$2);
    }

    public RunnerScriptServiceImpl(ExecuteRemotelyActorHolder executeRemotelyActorHolder, XlrConfig xlrConfig, JobRunnerService jobRunnerService) {
        this.executeRemotelyActorHolder = executeRemotelyActorHolder;
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
    }
}

