package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.runner.api.v1.RunnerRegistrationResource
import com.xebialabs.xlrelease.runner.api.v1.RunnerRegistrationResource.{RegisterRequest, RegisterResponse}
import com.xebialabs.xlrelease.runner.service.RunnerRegistrationService
import com.xebialabs.xlrelease.security.PermissionChecker
import org.springframework.stereotype.Controller

@Controller
class RunnerRegistrationResourceImpl(permissionChecker: PermissionChecker,
                                     runnerRegistrationService: RunnerRegistrationService)
  extends RunnerRegistrationResource {

  override def register(registerRequest: RegisterRequest): RegisterResponse = {
    permissionChecker.checkIsAllowedToRegisterRunner()
    runnerRegistrationService.register(registerRequest)
  }

}
