package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.runner.impl.RunnerControlChannelActor.{ChannelCommand, actorName}
import com.xebialabs.xlrelease.support.pekko.spring.{SpringActor, SpringExtension}
import org.apache.pekko.actor.{Actor, ActorLogging, ActorRef}

@SpringActor
class RunnerControlChannelSupervisor extends Actor with ActorLogging {
  override def receive: Receive = {
    case cmd: ChannelCommand =>
      log.debug(s"Received $cmd")
      createOrFind(cmd) forward cmd
    case msg =>
      log.error(s"Can't process $msg")
  }

  private def createOrFind(cmd: ChannelCommand): ActorRef = {
    val runnerId = cmd.runnerId
    val childName = actorName(runnerId)
    context.child(childName).getOrElse {
      log.debug(s"Creating an actor tree for $runnerId (triggered by $cmd)")
      SpringExtension.childActorOf(classOf[RunnerControlChannelActor], childName)
    }
  }
}
