import React, { useEffect } from 'react';
import { getIsLoadingSelector, getRemoteRunnersSelector } from '../ducks/remote-runners.selectors';
import { remoteRunners } from '../ducks/remote-runners.reducer';
import { RemoteRunner } from '../remote-runners.types';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../core/xlr-ui/app/js/hooks';
import { RemoteRunnersTableContainer } from './remote-runners-table-container';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { RemoteRunnersPlaceholder } from './remote-runners-placeholder.component';
import { INSTALL_REMOTE_RUNNER_WORKFLOW_SEARCH_CATEGORY } from '../remote-runner.constants';
import { workflow } from '../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

const { loadRemoteRunners } = remoteRunners.actions;
const { init } = workflow.actions;

export const RemoteRunnersContainer = () => {
    const dispatch = useAppDispatch();
    const isLoading: boolean = useAppSelector(getIsLoadingSelector);
    const runners: RemoteRunner[] = useAppSelector(getRemoteRunnersSelector);

    useEffect(() => {
        dispatch(loadRemoteRunners());
    }, []);

    const openWorkflowDrawer = () => {
        dispatch(init({ categories: [INSTALL_REMOTE_RUNNER_WORKFLOW_SEARCH_CATEGORY] }));
    };

    return (
        <DotThemeProvider>
            {runners.length > 0 ? (
                <RemoteRunnersTableContainer isLoading={isLoading} onViewChange={openWorkflowDrawer} runners={runners} />
            ) : (
                <RemoteRunnersPlaceholder onViewChange={openWorkflowDrawer} />
            )}
        </DotThemeProvider>
    );
};
