/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenCreatedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenDeletedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenUpdatedEvent;
import com.xebialabs.xlrelease.runner.repository.RunnerTokenRepository;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0007\u000e\u0001aA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)!\b\u0001C\u0001w!9\u0001\t\u0001b\u0001\n\u0013\t\u0005BB7\u0001A\u0003%!\tC\u0003o\u0001\u0011\u0005s\u000eC\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003C\u0002A\u0011IA2\u0005Y\u0011VO\u001c8feR{7.\u001a8TKJ4\u0018nY3J[Bd'B\u0001\b\u0010\u0003\u0011IW\u000e\u001d7\u000b\u0005A\t\u0012A\u0002:v]:,'O\u0003\u0002\u0013'\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003)U\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Y\t1aY8n\u0007\u0001\u0019B\u0001A\r KA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\b\u0002\u000fM,'O^5dK&\u0011A%\t\u0002\u0013%Vtg.\u001a:U_.,gnU3sm&\u001cW\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&\u0001\u0005he&T(\u0010\\3e\u0013\tasEA\u0004M_\u001e<\u0017N\\4\u0002!\t\u0014x.\u00193dCN$8+\u001a:wS\u000e,\u0007CA\u00182\u001b\u0005\u0001$B\u0001\u0012\u0012\u0013\t\u0011\u0004G\u0001\tCe>\fGmY1tiN+'O^5dK\u0006)\"/\u001e8oKJ$vn[3o%\u0016\u0004xn]5u_JL\bCA\u001b9\u001b\u00051$BA\u001c\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003sY\u0012QCU;o]\u0016\u0014Hk\\6f]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0004yyz\u0004CA\u001f\u0001\u001b\u0005i\u0001\"B\u0017\u0004\u0001\u0004q\u0003\"B\u001a\u0004\u0001\u0004!\u0014\u0001\u0005:v]:,'\u000fV8lK:\u001c\u0015m\u00195f+\u0005\u0011\u0005\u0003B\"K\u0019^k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bQaY1dQ\u0016T!a\u0012%\u0002\r\r|W.\\8o\u0015\tIU#\u0001\u0004h_><G.Z\u0005\u0003\u0017\u0012\u0013A\u0002T8bI&twmQ1dQ\u0016\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(\u001c\u001b\u0005\u0001&BA)\u0018\u0003\u0019a$o\\8u}%\u00111kG\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T7A\u0019!\u0004\u0017.\n\u0005e[\"AB(qi&|g\u000e\u0005\u0002\\U:\u0011Al\u001a\b\u0003;\u0016t!A\u00183\u000f\u0005}\u001bgB\u00011c\u001d\ty\u0015-C\u0001\u0017\u0013\t!R#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003M>\ta\u0001Z8nC&t\u0017B\u00015j\u0003\u001d\u0001\u0018mY6bO\u0016T!AZ\b\n\u0005-d'\u0001\u0003*v]:,'/\u00133\u000b\u0005!L\u0017!\u0005:v]:,'\u000fV8lK:\u001c\u0015m\u00195fA\u0005I2M]3bi\u0016|%/\u00169eCR,'+\u001e8oKJ$vn[3o)\r\u0001HO\u001e\t\u0003cJl\u0011![\u0005\u0003g&\u00141BU;o]\u0016\u0014Hk\\6f]\")QO\u0002a\u00015\u0006A!/\u001e8oKJLE\rC\u0003x\r\u0001\u0007\u00010\u0001\u0006fqBL'/\u001f#bi\u0016\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0003ECR,\u0007f\u0001\u0004\u0002\u0004A!\u0011QAA\n\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AC1o]>$\u0018\r^5p]*!\u0011QBA\b\u0003\u001diW\r\u001e:jGNT1!!\u0005\u0016\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u000b\u0003\u000f\u0011Q\u0001V5nK\u0012\f\u0011\u0003Z3mKR,'+\u001e8oKJ$vn[3o)\u0011\tY\"!\t\u0011\u0007i\ti\"C\u0002\u0002 m\u0011A!\u00168ji\")Qo\u0002a\u00015\"\u001aq!a\u0001\u0002\u0017\u0019Lg\u000e\u001a\"z)>\\WM\u001c\u000b\u0004/\u0006%\u0002BBA\u0016\u0011\u0001\u0007A*A\u0005u_.,g\u000eS1tQ\"\u001a\u0001\"a\u0001\u0002%=t'+\u001e8oKJ$vn[3o\u000bZ,g\u000e\u001e\u000b\u0005\u00037\t\u0019\u0004C\u0004\u00026%\u0001\r!a\u000e\u0002!I,hN\\3s)>\\WM\\#wK:$\bcA\u001f\u0002:%\u0019\u00111H\u0007\u0003!I+hN\\3s)>\\WM\\#wK:$\bfA\u0005\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FE\ta!\u001a<f]R\u001c\u0018\u0002BA%\u0003\u0007\u0012\u0011bU;cg\u000e\u0014\u0018NY3\u0002%=t'j\u001c2Sk:tWM\u001d#fY\u0016$X\r\u001a\u000b\u0005\u00037\ty\u0005C\u0004\u0002R)\u0001\r!a\u0015\u0002\u000b\u00154XM\u001c;\u0011\t\u0005U\u00131L\u0007\u0003\u0003/RA!!\u0012\u0002Z)\u0011a-E\u0005\u0005\u0003;\n9FA\rD_:4\u0017nZ;sCRLwN\u001c#fY\u0016$X\rZ#wK:$\bf\u0001\u0006\u0002@\u0005I\u0011n]#ya&\u0014X\r\u001a\u000b\u0005\u0003K\nY\u0007E\u0002\u001b\u0003OJ1!!\u001b\u001c\u0005\u001d\u0011un\u001c7fC:Da!a\u000b\f\u0001\u0004a\u0005fA\u0006\u0002\u0004!\u001a\u0001!!\u001d\u0011\t\u0005M\u0014\u0011Q\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u0005m\u0014QP\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011qP\u0001\u0004_J<\u0017\u0002BAB\u0003k\u0012qaU3sm&\u001cW\rK\u0002\u0001\u0003\u000f\u0003B!!\u0011\u0002\n&!\u00111RA\"\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\u0002")
public class RunnerTokenServiceImpl
implements RunnerTokenService,
Logging {
    private final BroadcastService broadcastService;
    public final RunnerTokenRepository com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository;
    private final LoadingCache<String, Option<String>> runnerTokenCache;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerTokenServiceImpl runnerTokenServiceImpl = this;
        synchronized (runnerTokenServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private LoadingCache<String, Option<String>> runnerTokenCache() {
        return this.runnerTokenCache;
    }

    @Timed
    public RunnerToken createOrUpdateRunnerToken(String runnerId, Date expiryDate) {
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RRA());
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        if (this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.exists(runnerId)) {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.update(runnerId, tokenHash, expiryDate);
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenUpdatedEvent(runnerId), true);
        } else {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.create(runnerId, tokenHash, expiryDate);
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenCreatedEvent(runnerId), true);
        }
        return new RunnerToken(runnerId, token);
    }

    @Timed
    public void deleteRunnerToken(String runnerId) {
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.delete(runnerId);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new RunnerTokenDeletedEvent(runnerId), true);
    }

    @Timed
    public Option<String> findByToken(String tokenHash) {
        return (Option)this.runnerTokenCache().get((Object)tokenHash);
    }

    @Subscribe
    public void onRunnerTokenEvent(RunnerTokenEvent runnerTokenEvent) {
        this.runnerTokenCache().invalidateAll();
    }

    @Subscribe
    public void onJobRunnerDeleted(ConfigurationDeletedEvent event) {
        BaseConfiguration config = event.conf();
        BaseConfiguration baseConfiguration = config;
        if (baseConfiguration instanceof RemoteJobRunner) {
            RemoteJobRunner remoteJobRunner = (RemoteJobRunner)baseConfiguration;
            this.logger().trace((Function0 & Serializable)() -> "Deleting all tokens associated with runner [" + remoteJobRunner.getId() + "]");
            this.deleteRunnerToken(remoteJobRunner.getId());
            return;
        }
    }

    @Timed
    public boolean isExpired(String tokenHash) {
        Option option = this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.findExpiryDate(tokenHash);
        if (option instanceof Some) {
            Some some = (Some)option;
            Date expiryDate = (Date)some.value();
            return expiryDate.getTime() < System.currentTimeMillis();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public RunnerTokenServiceImpl(BroadcastService broadcastService, RunnerTokenRepository runnerTokenRepository) {
        this.broadcastService = broadcastService;
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository = runnerTokenRepository;
        Logging.$init$((Logging)this);
        this.runnerTokenCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Option<String>>(this){
            private final /* synthetic */ RunnerTokenServiceImpl $outer;

            public Option<String> load(String tokenHash) {
                return this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.findByToken(tokenHash);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

