import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import './remote-runners-placeholder.component.less';

export interface RemoteRunnersPlaceholderProps {
    onViewChange: () => void;
}

export const RemoteRunnersPlaceholder = ({ onViewChange }: RemoteRunnersPlaceholderProps) => {
    return (
        <div className="remote-runners-placeholder">
            <div className="remote-runners">
                <img alt="Remote runners" src={`static/@project.version@/include/remote-runners/assets/remote-runners.svg`} width="300" />
                <div className="remote-runners-title">Add remote runner</div>
                <div className="remote-runners-description">
                    Remote runner overview are meant to help you bring connection between your on-prem services and cloud SAAS software
                    <div className="remote-runners-buttons">
                        <DotButton className="remote-runners-create-btn" data-testid="create-btn" onClick={onViewChange} type="primary">
                            Add remote runner
                        </DotButton>
                    </div>
                </div>
            </div>
        </div>
    );
};
