/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyFactory;
import com.xebialabs.xlrelease.service.ConfigurationService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.slf4j.Marker;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u001dI\u0005A1A\u0005\n)Caa\u0015\u0001!\u0002\u0013Y\u0005\"\u0002+\u0001\t\u0003)\u0006\"B9\u0001\t\u0013\u0011\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\u0012\u0011DU;o]\u0016\u0014\u0018I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dK*\u0011q\u0002E\u0001\u0005S6\u0004HN\u0003\u0002\u0012%\u00051!/\u001e8oKJT!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!B:mMRR'\"A\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003YI\taaY8oM&<\u0017B\u0001\u0018,\u0005%AFN]\"p]\u001aLw-A\nk_\n\u0014VO\u001c8feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022i5\t!G\u0003\u00024%\u0005Q!/\u001a9pg&$xN]=\n\u0005U\u0012$a\u0005&pEJ+hN\\3s%\u0016\u0004xn]5u_JL\u0018A\u0005:v]:,'\u000f\u0015:pqf4\u0015m\u0019;pef\u0004\"\u0001O\u001d\u000e\u00039I!A\u000f\b\u0003%I+hN\\3s!J|\u00070\u001f$bGR|'/_\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0012aB:feZL7-Z\u0005\u0003\u0003z\u0012AcQ8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003E\u000b\u001a;\u0005\n\u0005\u00029\u0001!)\u0001&\u0002a\u0001S!)q&\u0002a\u0001a!)a'\u0002a\u0001o!)1(\u0002a\u0001y\u0005\t\u0012M^1jY\u0006\u0014G.\u001a)s_B,'\u000f^=\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0004TiJLgnZ\u0001\u0013CZ\f\u0017\u000e\\1cY\u0016\u0004&o\u001c9feRL\b%A\u0003bY&4X\r\u0006\u0002W3B\u00111dV\u0005\u00031r\u0011A!\u00168ji\")!\f\u0003a\u00017\u0006A!/\u001e8oKJLE\r\u0005\u0002]]:\u0011Ql\u001b\b\u0003=&t!a\u00185\u000f\u0005\u0001<gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!\u0007$\u0001\u0004=e>|GOP\u0005\u0002/%\u0011QCF\u0005\u0003'QI!!\u0005\n\n\u0005)\u0004\u0012A\u00023p[\u0006Lg.\u0003\u0002m[\u00069\u0001/Y2lC\u001e,'B\u00016\u0011\u0013\ty\u0007O\u0001\u0005Sk:tWM]%e\u0015\taW.\u0001\rdQ\u0016\u001c7NU;o]\u0016\u00148/\u0011<bS2\f'-\u001b7jif$\u0012A\u0016\u0015\u000b\u0013Q\f\t!a\u0001\u0002\u0006\u0005\r\u0001CA;\u007f\u001b\u00051(BA<y\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003sj\f!b]2iK\u0012,H.\u001b8h\u0015\tYH0A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005i\u0018aA8sO&\u0011qP\u001e\u0002\n'\u000eDW\rZ;mK\u0012\fA\"\u001b8ji&\fG\u000eR3mCft2\u0001\u0001va\u0003%1\u0017\u000e_3e%\u0006$X-A\bjgJ+hN\\3s\u000bb\u0004\u0018N]3e)!\tY!!\u0005\u0002 \u0005U\u0002cA\u000e\u0002\u000e%\u0019\u0011q\u0002\u000f\u0003\u000f\t{w\u000e\\3b]\"1\u0011C\u0003a\u0001\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004#\u0005e!B\u00016\u0013\u0013\u0011\ti\"a\u0006\u0003\u0013){'MU;o]\u0016\u0014\bbBA\u0011\u0015\u0001\u0007\u00111E\u0001\u0005Y\u0006\u001cH\u000f\u0005\u0003\u0002&\u0005=b\u0002BA\u0014\u0003Wq1AXA\u0015\u0013\ty\u0001#C\u0002\u0002.9\t\u0001CU;o]\u0016\u0014\bK]8ys\u0006\u001bGo\u001c:\n\t\u0005E\u00121\u0007\u0002\u0017\u0019\u0006\u001cHOU;o]\u0016\u0014H+[7f%\u0016\u001c\bo\u001c8tK*\u0019\u0011Q\u0006\b\t\u000f\u0005]\"\u00021\u0001\u0002:\u0005Y1-\u001e:sK:$H+[7f!\rY\u00121H\u0005\u0004\u0003{a\"\u0001\u0002'p]\u001e\f\u0001$\\1q%Vtg.\u001a:U_2\u000b7\u000f\u001e+j[\u0016\fE.\u001b<f)\u0011\t\u0019%a\u0014\u0011\u000fm\t)%a\u0005\u0002J%\u0019\u0011q\t\u000f\u0003\rQ+\b\u000f\\33!\u0015Y\u00121JA\u0012\u0013\r\ti\u0005\b\u0002\u0007\u001fB$\u0018n\u001c8\t\rEY\u0001\u0019AA\n\u0003a)\b\u000fZ1uKJ+hN\\3s\u0003Z\f\u0017\u000e\\1cS2LG/\u001f\u000b\u0006-\u0006U\u0013q\u000b\u0005\u0007#1\u0001\r!a\u0005\t\u000f\u0005eC\u00021\u0001\u0002\f\u0005I\u0011M^1jY\u0006\u0014G.\u001a\u0015\u0004\u0001\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r$0\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u001a\u0002b\t91+\u001a:wS\u000e,\u0007")
public class RunnerAvailabilityService
implements Logging {
    private final XlrConfig xlrConfig;
    private final JobRunnerRepository jobRunnerRepository;
    private final RunnerProxyFactory runnerProxyFactory;
    private final ConfigurationService configurationService;
    private final String availableProperty;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerAvailabilityService runnerAvailabilityService = this;
        synchronized (runnerAvailabilityService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private String availableProperty() {
        return this.availableProperty;
    }

    public void alive(String runnerId) {
        this.jobRunnerRepository.findRunner(runnerId).foreach((Function1 & Serializable)runner -> {
            RunnerAvailabilityService.$anonfun$alive$1(this, runner);
            return BoxedUnit.UNIT;
        });
    }

    @Scheduled(initialDelay=60000L, fixedRate=60000L)
    private void checkRunnersAvailability() {
        long currentTime = System.currentTimeMillis();
        ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jobRunnerRepository.findAll()).asScala().map((Function1 & Serializable)runner -> this.mapRunnerToLastTimeAlive((JobRunner)runner))).collect((PartialFunction)new Serializable(this, currentTime){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RunnerAvailabilityService $outer;
            private final long currentTime$1;

            public final <A1 extends Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    RunnerProxyActor.LastRunnerTimeResponse last;
                    JobRunner runner = (JobRunner)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(runner, last = (RunnerProxyActor.LastRunnerTimeResponse)(some = (Some)option).value(), this.currentTime$1)) {
                        return (B1)runner;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> x1) {
                Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> tuple2 = x1;
                if (tuple2 != null) {
                    Some some;
                    RunnerProxyActor.LastRunnerTimeResponse last;
                    JobRunner runner = (JobRunner)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some && this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(runner, last = (RunnerProxyActor.LastRunnerTimeResponse)(some = (Some)option).value(), this.currentTime$1)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTime$1 = currentTime$1;
            }
        })).foreach((Function1 & Serializable)runner -> {
            RunnerAvailabilityService.$anonfun$checkRunnersAvailability$3(this, runner);
            return BoxedUnit.UNIT;
        });
    }

    public boolean com$xebialabs$xlrelease$runner$impl$RunnerAvailabilityService$$isRunnerExpired(JobRunner runner, RunnerProxyActor.LastRunnerTimeResponse last, long currentTime) {
        return runner.isAvailable() && last.timestamp().isDefined() && Predef$.MODULE$.Integer2int(runner.idleTimeToLive()) > 0 && currentTime - BoxesRunTime.unboxToLong((Object)last.timestamp().get()) > (long)(Predef$.MODULE$.Integer2int(runner.idleTimeToLive()) * 1000);
    }

    private Tuple2<JobRunner, Option<RunnerProxyActor.LastRunnerTimeResponse>> mapRunnerToLastTimeAlive(JobRunner runner) {
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActorReceive());
        Option lastTimeAlive = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ActorRef qual$1 = package$.MODULE$.ask($this.runnerProxyFactory.create(BoxedUnit.UNIT));
            RunnerProxyActor.LastRunnerTime x$1 = new RunnerProxyActor.LastRunnerTime(runner.getId());
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            return (RunnerProxyActor.LastRunnerTimeResponse)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }).toOption();
        return new Tuple2((Object)runner, (Object)lastTimeAlive);
    }

    private void updateRunnerAvailability(JobRunner runner, boolean available) {
        runner.setProperty(this.availableProperty(), (Object)BoxesRunTime.boxToBoolean((boolean)available));
        this.configurationService.createOrUpdate((BaseConfiguration)runner);
    }

    public static final /* synthetic */ void $anonfun$alive$1(RunnerAvailabilityService $this, JobRunner runner) {
        if (!runner.isAvailable()) {
            $this.logger().info((Function0 & Serializable)() -> "Unavailable runner '" + runner.getId() + "' confirmed it's alive again and will be marked as available");
            $this.updateRunnerAvailability(runner, true);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkRunnersAvailability$3(RunnerAvailabilityService $this, JobRunner runner) {
        $this.logger().warn((Function0 & Serializable)() -> "Runner '" + runner.getId() + "' failed to confirm it's alive for more than " + runner.idleTimeToLive() + " seconds and will be marked as unavailable");
        $this.updateRunnerAvailability(runner, false);
    }

    public RunnerAvailabilityService(XlrConfig xlrConfig, JobRunnerRepository jobRunnerRepository, RunnerProxyFactory runnerProxyFactory, ConfigurationService configurationService) {
        this.xlrConfig = xlrConfig;
        this.jobRunnerRepository = jobRunnerRepository;
        this.runnerProxyFactory = runnerProxyFactory;
        this.configurationService = configurationService;
        Logging.$init$((Logging)this);
        this.availableProperty = "available";
    }
}

