package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.domain.RemoteExecution
import com.xebialabs.xlrelease.domain.runner.JobRunner
import com.xebialabs.xlrelease.support.pekko.spring.SpringActor
import org.apache.pekko.actor.{Actor, ActorLogging, ActorRef}

import java.util

@SpringActor
class ExecuteRemotelyActor extends Actor with ActorLogging {
  def receive: Receive = onMessage(Map.empty)

  private def onMessage(jobActors: Map[String, ActorRef]): Receive = {
    case msg: ExecuteRemotely =>
      log.debug(s"Received $msg")
      val scriptExecutionId = msg.jobRunner.execute(msg.remoteExecution)
      context.become(onMessage(jobActors + (scriptExecutionId -> sender())))
    case msg: ExecuteRemotelyResponse =>
      jobActors.get(msg.scriptExecutionId).foreach { replyTo =>
        replyTo ! msg
        context.become(onMessage(jobActors - msg.scriptExecutionId))
      }
    case msg =>
      log.error(s"Can't process $msg")
  }
}

case class ExecuteRemotely(jobRunner: JobRunner, remoteExecution: RemoteExecution)
case class ExecuteRemotelyResponse(scriptExecutionId: String, payload: util.Map[String, AnyRef])
