import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mockResizeObserver, mountComponentWithStore } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { RemoteRunnersTableContainer } from './remote-runners-table-container';
import { RemoteRunnersTable } from './remote-runners-table';
import { initialState, remoteRunners } from '../ducks/remote-runners.reducer';
import { remoteRunnerMock } from '../__mocks__/remote-runners.mocks';
import { ConnectionDialog } from '../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/common/connection-dialog/connection-dialog.component';
import { DotConfirmationDialog, DotIconButton } from '@digital-ai/dot-components';
import { initialState as taskDrawerInitialState } from '../../../../../../../../../core/xlr-ui/app/features/tasks/ducks/task-drawer-connection.reducer';
import { initializedConfigurationStateMock } from '../../../../../../../../../core/xlr-ui/app/features/configuration/components/instance/__mocks__/configuration-instance-form.mock';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';

const { loadRemoteRunners } = remoteRunners.actions;

describe('RemoteRunnersTableContainer component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const fakeEvent = {
        stopPropagation: jest.fn(),
    };

    const defaultState: RootState = {
        remoteRunners: {
            ...initialState,
            remoteRunners: [remoteRunnerMock],
        },
        taskDrawerConnection: {
            ...taskDrawerInitialState,
        },
        configuration: {
            ...initializedConfigurationStateMock,
        },
    };
    const mountComponent = (state: RootState = defaultState) => {
        wrapper = mountComponentWithStore(<RemoteRunnersTableContainer />, dispatch, state);
        expect(wrapper.find(Provider)).toExist();
        expect(dispatch).toHaveBeenCalledWith(loadRemoteRunners());
    };

    beforeAll(() => {
        mockResizeObserver();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render remote runners table', () => {
        mountComponent();
        expect(wrapper.find(RemoteRunnersTable)).toExist();
    });

    it('should render remote runner connection dialog after click on edit button', () => {
        mountComponent();
        expect(wrapper.find(RemoteRunnersTable)).toExist();

        const editButton = wrapper.findWhere((node) => node.is(DotIconButton) && node.props().tooltip === 'Edit').at(0);
        expect(editButton).toExist();
        editButton.invoke('onClick')(fakeEvent);
        wrapper.update();

        expect(wrapper.find(ConnectionDialog)).toExist();
    });

    it('should render remote runner delete dialog after click on delete button', () => {
        mountComponent();
        expect(wrapper.find(RemoteRunnersTable)).toExist();

        const deleteButton = wrapper.findWhere((node) => node.is(DotIconButton) && node.props().tooltip === 'Delete').at(0);
        expect(deleteButton).toExist();
        deleteButton.invoke('onClick')(fakeEvent);
        wrapper.update();

        expect(wrapper.find(DotConfirmationDialog)).toExist();
    });
});
