/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotely;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyActor;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyResponse;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\b\u0011\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003=\u0001\u0011\u0005Q\b\u0003\u0005C\u0001!\u0015\r\u0011\"\u0003D\u0011\u001dy\u0005A1A\u0005\nACa!\u0017\u0001!\u0002\u0013\t\u0006b\u0002.\u0001\u0005\u0004%I\u0001\u0015\u0005\u00077\u0002\u0001\u000b\u0011B)\t\u000bq\u0003A\u0011B/\t\u000b!\u0004A\u0011B5\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0002\u0018%Vtg.\u001a:TGJL\u0007\u000f^*feZL7-Z%na2T!!\u0005\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003'Q\taA];o]\u0016\u0014(BA\u000b\u0017\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00181\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00023\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u0011\u0013\t)\u0003CA\nSk:tWM]*de&\u0004HoU3sm&\u001cW-A\btaJLgnZ#yi\u0016t7/[8o!\tAs&D\u0001*\u0015\tQ3&\u0001\u0004taJLgn\u001a\u0006\u0003Y5\nQ\u0001]3lW>T!A\f\u000b\u0002\u000fM,\b\u000f]8si&\u0011\u0001'\u000b\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kQ\taaY8oM&<\u0017BA\u001c5\u0005%AFN]\"p]\u001aLw-\u0001\tk_\n\u0014VO\u001c8feN+'O^5dKB\u00111EO\u0005\u0003wA\u0011\u0001CS8c%Vtg.\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011qt\bQ!\u0011\u0005\r\u0002\u0001\"\u0002\u0014\u0005\u0001\u00049\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0014\u0001C1di>\u0014(+\u001a4\u0016\u0003\u0011\u0003\"!R'\u000e\u0003\u0019S!a\u0012%\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00051J%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!A\u0014$\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f!cQ8n[\u0006tGMU3ta>t7/Z&fsV\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\rM#(/\u001b8h\u0003M\u0019u.\\7b]\u0012\u0014Vm\u001d9p]N,7*Z=!\u0003=)%O]8s\u001b\u0016\u001c8/Y4f\u0017\u0016L\u0018\u0001E#se>\u0014X*Z:tC\u001e,7*Z=!\u00031y'M[3di6\u000b\u0007\u000f]3s+\u0005q\u0006CA0g\u001b\u0005\u0001'BA1c\u0003!!\u0017\r^1cS:$'BA2e\u0003\u001dQ\u0017mY6t_:T!!\u001a\r\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA4a\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003-\t7o[!oI\u0006;\u0018-\u001b;\u0016\u0005)lGcA6w\u007fB\u0011A.\u001c\u0007\u0001\t\u0015q7B1\u0001p\u0005\u0005!\u0016C\u00019t!\ti\u0012/\u0003\u0002s=\t9aj\u001c;iS:<\u0007CA\u000fu\u0013\t)hDA\u0002B]fDQa^\u0006A\u0002a\f\u0011B[8c%Vtg.\u001a:\u0011\u0005elX\"\u0001>\u000b\u0005MY(B\u0001?\u0015\u0003\u0019!w.\\1j]&\u0011aP\u001f\u0002\n\u0015>\u0014'+\u001e8oKJDq!!\u0001\f\u0001\u0004\t\u0019!A\bsK6|G/Z#yK\u000e,H/[8o!\u0011\t)!a\u0002\u000e\u0003mL1!!\u0003|\u0005=\u0011V-\\8uK\u0016CXmY;uS>t\u0017!D3yK\u000e,H/Z*de&\u0004H/\u0006\u0003\u0002\u0010\u0005MA\u0003CA\t\u0003+\ti#!\u0010\u0011\u00071\f\u0019\u0002B\u0003o\u0019\t\u0007q\u000eC\u0004\u0002\u00181\u0001\r!!\u0007\u0002\rM\u001c'/\u001b9u!\u0011\tY\"!\u000b\u000f\t\u0005u\u0011Q\u0005\t\u0004\u0003?qRBAA\u0011\u0015\r\t\u0019CG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001db$\u0001\u0004Qe\u0016$WMZ\u0005\u00041\u0006-\"bAA\u0014=!9\u0011q\u0006\u0007A\u0002\u0005E\u0012aD5oaV$\b+\u0019:b[\u0016$XM]:\u0011\u000f\u0005M\u0012\u0011HA\r95\u0011\u0011Q\u0007\u0006\u0004\u0003o)\u0016\u0001B;uS2LA!a\u000f\u00026\t\u0019Q*\u00199\t\u000f\u0005}B\u00021\u0001\u0002B\u0005iA/\u001f9f%\u00164WM]3oG\u0016\u0004b!a\u0011\u0002N\u0005EQBAA#\u0015\u0011\t9%!\u0013\u0002\tQL\b/\u001a\u0006\u0004\u0003\u0017\u0012\u0017\u0001B2pe\u0016LA!a\u0014\u0002F\tiA+\u001f9f%\u00164WM]3oG\u0016\fq\"\u001a=fGV$XMU3n_R,G.\u001f\u000b\u0007\u0003+\nY&!\u0018\u0011\u0007\r\n9&C\u0002\u0002ZA\u0011q#\u0012=fGV$XMU3n_R,G.\u001f*fgB|gn]3\t\u000f\u0005]Q\u00021\u0001\u0002\u001a!9\u0011qF\u0007A\u0002\u0005E\u0012AD:de&\u0004H/\u0012=fGV$X\r\u001a\u000b\u0007\u0003G\nI'!\u001c\u0011\u0007u\t)'C\u0002\u0002hy\u0011A!\u00168ji\"9\u00111\u000e\bA\u0002\u0005e\u0011!E:de&\u0004H/\u0012=fGV$\u0018n\u001c8JI\"9\u0011q\u000e\bA\u0002\u0005E\u0012a\u00029bs2|\u0017\r\u001a\u0015\u0004\u0001\u0005M\u0004\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\u000bgR,'/Z8usB,'bAA?\u0017\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002\u0002\u0006]$aB*feZL7-\u001a")
public class RunnerScriptServiceImpl
implements RunnerScriptService {
    private ActorRef actorRef;
    private final SpringExtension springExtension;
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private final String CommandResponseKey;
    private final String ErrorMessageKey;
    private volatile boolean bitmap$0;

    private ActorRef actorRef$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(ExecuteRemotelyActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private String CommandResponseKey() {
        return this.CommandResponseKey;
    }

    private String ErrorMessageKey() {
        return this.ErrorMessageKey;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private <T> T askAndAwait(JobRunner jobRunner, RemoteExecution remoteExecution) {
        Object object;
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActionResponse());
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.actorRef());
            ExecuteRemotely x$1 = new ExecuteRemotely(jobRunner, remoteExecution);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }
        catch (Exception e) {
            throw new ContainerScriptException(e.getMessage());
        }
        return (T)object;
    }

    @Override
    public <T> T executeScript(String script, java.util.Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)this.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)this.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)this.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ExecuteRemotelyResponse executeRemotely(String script, java.util.Map<String, Object> inputParameters) {
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ContainerScriptException("Cannot find active script runner for executing '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        return (ExecuteRemotelyResponse)this.askAndAwait(runner2, (RemoteExecution)scriptTask);
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, java.util.Map<String, Object> payload) {
        ExecuteRemotelyResponse x$1 = new ExecuteRemotelyResponse(scriptExecutionId, payload);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
        this.actorRef().$bang((Object)x$1, x$2);
    }

    public RunnerScriptServiceImpl(SpringExtension springExtension, XlrConfig xlrConfig, JobRunnerService jobRunnerService) {
        this.springExtension = springExtension;
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
        this.CommandResponseKey = "commandResponse";
        this.ErrorMessageKey = "errorMessage";
    }
}

