package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner
import com.xebialabs.xlrelease.runner.crypto.encrypt.JobRSAUtils
import com.xebialabs.xlrelease.runner.crypto.encrypt.JobRSAUtils.DEFAULT_KEY_VERSION
import com.xebialabs.xlrelease.runner.domain.{ContextData, EncryptedContextData, PlainContextData}
import com.xebialabs.xlrelease.script.EncryptionHelper
import org.springframework.util.StringUtils.hasText

object ContextDataHelper {

  def encryptData(runner: RemoteJobRunner, data: String): ContextData = {
    if (runner.encryptJobData && hasText(data)) {
      EncryptionHelper.decrypt(runner)
      if (hasText(runner.getPublicKey)) {
        JobRSAUtils.encryptContextData(data, runner.getPublicKey, DEFAULT_KEY_VERSION)
      } else {
        throw new RuntimeException(s"Could not find public key associated with runner[${runner.getId}]")
      }
    } else {
      PlainContextData(data)
    }
  }

  def decryptData(runner: RemoteJobRunner, encryptedData: EncryptedContextData): PlainContextData = {
    EncryptionHelper.decrypt(runner)
    if (hasText(runner.getPublicKey)) {
      JobRSAUtils.decryptContextData(encryptedData, runner.getPublicKey)
    } else {
      throw new RuntimeException(s"Could not find public key associated with runner[${runner.getId}]")
    }
  }

}
