/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenCreatedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenDeletedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenUpdatedEvent;
import com.xebialabs.xlrelease.runner.repository.RunnerTokenRepository;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\u0006\r\u0001]A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!)\u0011\b\u0001C\u0001u!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u00027\u0001A\u0003%\u0011\tC\u0003n\u0001\u0011\u0005c\u000eC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0002\u0017%Vtg.\u001a:U_.,gnU3sm&\u001cW-S7qY*\u0011QBD\u0001\u0005S6\u0004HN\u0003\u0002\u0010!\u00051!/\u001e8oKJT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001D\b\u0013\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\"%D\u0001!\u0015\t\tc\"A\u0004tKJ4\u0018nY3\n\u0005\r\u0002#A\u0005*v]:,'\u000fV8lK:\u001cVM\u001d<jG\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\tce>\fGmY1tiN+'O^5dKB\u0011a\u0006M\u0007\u0002_)\u0011\u0011\u0005E\u0005\u0003c=\u0012\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002+I,hN\\3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ssB\u0011AgN\u0007\u0002k)\u0011aGD\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001d6\u0005U\u0011VO\u001c8feR{7.\u001a8SKB|7/\u001b;pef\fa\u0001P5oSRtDcA\u001e>}A\u0011A\bA\u0007\u0002\u0019!)Af\u0001a\u0001[!)!g\u0001a\u0001g\u0005\u0001\"/\u001e8oKJ$vn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0002\u0003B!!)S&W\u001b\u0005\u0019%B\u0001#F\u0003\u0015\u0019\u0017m\u00195f\u0015\t1u)\u0001\u0004d_6lwN\u001c\u0006\u0003\u0011R\taaZ8pO2,\u0017B\u0001&D\u00051au.\u00193j]\u001e\u001c\u0015m\u00195f!\ta5K\u0004\u0002N#B\u0011aJG\u0007\u0002\u001f*\u0011\u0001KF\u0001\u0007yI|w\u000e\u001e \n\u0005IS\u0012A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\u000e\u0011\u0007e9\u0016,\u0003\u0002Y5\t1q\n\u001d;j_:\u0004\"AW5\u000f\u0005m3gB\u0001/e\u001d\ti6M\u0004\u0002_E:\u0011q,\u0019\b\u0003\u001d\u0002L\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA3\u000f\u0003\u0019!w.\\1j]&\u0011q\r[\u0001\ba\u0006\u001c7.Y4f\u0015\t)g\"\u0003\u0002kW\nA!+\u001e8oKJLEM\u0003\u0002hQ\u0006\t\"/\u001e8oKJ$vn[3o\u0007\u0006\u001c\u0007.\u001a\u0011\u00023\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKJ+hN\\3s)>\\WM\u001c\u000b\u0003_N\u0004\"\u0001]9\u000e\u0003!L!A\u001d5\u0003\u0017I+hN\\3s)>\\WM\u001c\u0005\u0006i\u001a\u0001\r!W\u0001\teVtg.\u001a:JI\"\u0012aA\u001e\t\u0003ozl\u0011\u0001\u001f\u0006\u0003sj\f!\"\u00198o_R\fG/[8o\u0015\tYH0A\u0004nKR\u0014\u0018nY:\u000b\u0005u$\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005}D(!\u0002+j[\u0016$\u0017!\u00053fY\u0016$XMU;o]\u0016\u0014Hk\\6f]R!\u0011QAA\u0006!\rI\u0012qA\u0005\u0004\u0003\u0013Q\"\u0001B+oSRDQ\u0001^\u0004A\u0002eC#a\u0002<\u0002\u0017\u0019Lg\u000e\u001a\"z)>\\WM\u001c\u000b\u0004-\u0006M\u0001BBA\u000b\u0011\u0001\u00071*A\u0005u_.,g\u000eS1tQ\"\u0012\u0001B^\u0001\u0013_:\u0014VO\u001c8feR{7.\u001a8Fm\u0016tG\u000f\u0006\u0003\u0002\u0006\u0005u\u0001bBA\u0010\u0013\u0001\u0007\u0011\u0011E\u0001\u0011eVtg.\u001a:U_.,g.\u0012<f]R\u00042\u0001PA\u0012\u0013\r\t)\u0003\u0004\u0002\u0011%Vtg.\u001a:U_.,g.\u0012<f]RD3!CA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018!\u00051QM^3oiNLA!a\r\u0002.\tI1+\u001e2tGJL'-Z\u0001\u0013_:TuN\u0019*v]:,'\u000fR3mKR,G\r\u0006\u0003\u0002\u0006\u0005e\u0002bBA\u001e\u0015\u0001\u0007\u0011QH\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u0011qFA\"\u0015\t)\u0007#\u0003\u0003\u0002H\u0005\u0005#!G\"p]\u001aLw-\u001e:bi&|g\u000eR3mKR,G-\u0012<f]RD3ACA\u0015Q\r\u0001\u0011Q\n\t\u0005\u0003W\ty%\u0003\u0003\u0002R\u00055\"!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u0003+\u0002B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a\u0018\u0002b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002d\u0005\u0019qN]4\n\t\u0005\u001d\u0014\u0011\f\u0002\b'\u0016\u0014h/[2f\u0001")
public class RunnerTokenServiceImpl
implements RunnerTokenService,
Logging {
    private final BroadcastService broadcastService;
    public final RunnerTokenRepository com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository;
    private final LoadingCache<String, Option<String>> runnerTokenCache;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RunnerTokenServiceImpl runnerTokenServiceImpl = this;
        synchronized (runnerTokenServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private LoadingCache<String, Option<String>> runnerTokenCache() {
        return this.runnerTokenCache;
    }

    @Timed
    public RunnerToken createOrUpdateRunnerToken(String runnerId) {
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RRA());
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        if (this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.exists(runnerId)) {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.update(runnerId, tokenHash);
            this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenUpdatedEvent(runnerId), true);
        } else {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.create(runnerId, tokenHash);
            this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenCreatedEvent(runnerId), true);
        }
        return new RunnerToken(runnerId, token);
    }

    @Timed
    public void deleteRunnerToken(String runnerId) {
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.delete(runnerId);
        this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenDeletedEvent(runnerId), true);
    }

    @Timed
    public Option<String> findByToken(String tokenHash) {
        return (Option)this.runnerTokenCache().get((Object)tokenHash);
    }

    @Subscribe
    public void onRunnerTokenEvent(RunnerTokenEvent runnerTokenEvent) {
        this.runnerTokenCache().invalidateAll();
    }

    @Subscribe
    public void onJobRunnerDeleted(ConfigurationDeletedEvent event) {
        BaseConfiguration config = event.conf();
        BaseConfiguration baseConfiguration = config;
        if (baseConfiguration instanceof RemoteJobRunner) {
            RemoteJobRunner remoteJobRunner = (RemoteJobRunner)baseConfiguration;
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Deleting all tokens associated with runner [").append(remoteJobRunner.getId()).append("]").toString());
            this.deleteRunnerToken(remoteJobRunner.getId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public RunnerTokenServiceImpl(BroadcastService broadcastService, RunnerTokenRepository runnerTokenRepository) {
        this.broadcastService = broadcastService;
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository = runnerTokenRepository;
        Logging.$init$((Logging)this);
        this.runnerTokenCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Option<String>>(this){
            private final /* synthetic */ RunnerTokenServiceImpl $outer;

            public Option<String> load(String tokenHash) {
                return this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.findByToken(tokenHash);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

