package com.xebialabs.xlrelease.runner.impl

import akka.actor.ActorRef
import com.xebialabs.xlrelease.runner.domain.RunnerId
import com.xebialabs.xlrelease.runner.impl.RunnerControlChannelActor._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor.ConfirmCommand
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension
import org.springframework.stereotype.Service

import javax.ws.rs.sse.{Sse, SseEventSink}

@Service
class RunnerControlService(springExtension: SpringExtension, runnerProxyFactory: RunnerProxyFactory) {

  private lazy val runnerChannelRef: ActorRef = springExtension.actorOf(classOf[RunnerControlChannelSupervisor])

  def watch(runnerId: RunnerId, sink: SseEventSink, sse: Sse): Unit = {
    runnerChannelRef ! OpenControlChannel(runnerId, sink, sse)
  }

  def closeControlChannel(runnerId: RunnerId): Unit = {
    runnerChannelRef ! CloseControlChannel(runnerId)
  }

  def confirmCommand(runnerId: RunnerId, commandId: String): Unit = {
    runnerProxyFactory.create(()) ! ConfirmCommand(runnerId, commandId)
  }

}
