/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenCreatedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenDeletedEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenEvent;
import com.xebialabs.xlrelease.runner.impl.RunnerTokenUpdatedEvent;
import com.xebialabs.xlrelease.runner.repository.RunnerTokenRepository;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u0006\f\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)\u0001\u0007\u0001C\u0001c!9a\u0007\u0001b\u0001\n\u00139\u0004BB2\u0001A\u0003%\u0001\bC\u0003e\u0001\u0011\u0005S\rC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\b\u0001!\t!!\u0003\u0003-I+hN\\3s)>\\WM\\*feZL7-Z%na2T!\u0001D\u0007\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u001d=\taA];o]\u0016\u0014(B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq\u0012%D\u0001 \u0015\t\u0001S\"A\u0004tKJ4\u0018nY3\n\u0005\tz\"A\u0005*v]:,'\u000fV8lK:\u001cVM\u001d<jG\u0016\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005\u0015:S\"\u0001\u0014\u000b\u0005\u0001z\u0011B\u0001\u0015'\u0005A\u0011%o\\1eG\u0006\u001cHoU3sm&\u001cW-A\u000bsk:tWM\u001d+pW\u0016t'+\u001a9pg&$xN]=\u0011\u0005-rS\"\u0001\u0017\u000b\u00055j\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0006\f\u0002\u0016%Vtg.\u001a:U_.,gNU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0019!\u0007N\u001b\u0011\u0005M\u0002Q\"A\u0006\t\u000b\r\u001a\u0001\u0019\u0001\u0013\t\u000b%\u001a\u0001\u0019\u0001\u0016\u0002!I,hN\\3s)>\\WM\\\"bG\",W#\u0001\u001d\u0011\te\u0002%)T\u0007\u0002u)\u00111\bP\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003{y\naaY8n[>t'BA \u0014\u0003\u00199wn\\4mK&\u0011\u0011I\u000f\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015KR\"\u0001$\u000b\u0005\u001d+\u0012A\u0002\u001fs_>$h(\u0003\u0002J3\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tI\u0015\u0004E\u0002\u0019\u001dBK!aT\r\u0003\r=\u0003H/[8o!\t\t\u0006M\u0004\u0002S;:\u00111k\u0017\b\u0003)js!!V-\u000f\u0005YCfBA#X\u0013\u0005!\u0012B\u0001\n\u0014\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011A,D\u0001\u0007I>l\u0017-\u001b8\n\u0005y{\u0016a\u00029bG.\fw-\u001a\u0006\u000396I!!\u00192\u0003\u0011I+hN\\3s\u0013\u0012T!AX0\u0002#I,hN\\3s)>\\WM\\\"bG\",\u0007%A\rde\u0016\fG/Z(s+B$\u0017\r^3Sk:tWM\u001d+pW\u0016tGC\u00014k!\t9\u0007.D\u0001`\u0013\tIwLA\u0006Sk:tWM\u001d+pW\u0016t\u0007\"B6\u0007\u0001\u0004\u0001\u0016\u0001\u0003:v]:,'/\u00133)\u0005\u0019i\u0007C\u00018v\u001b\u0005y'B\u00019r\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003eN\fq!\\3ue&\u001c7O\u0003\u0002u'\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002w_\n)A+[7fI\u0006\tB-\u001a7fi\u0016\u0014VO\u001c8feR{7.\u001a8\u0015\u0005ed\bC\u0001\r{\u0013\tY\u0018D\u0001\u0003V]&$\b\"B6\b\u0001\u0004\u0001\u0006FA\u0004n\u0003-1\u0017N\u001c3CsR{7.\u001a8\u0015\u00075\u000b\t\u0001\u0003\u0004\u0002\u0004!\u0001\rAQ\u0001\ni>\\WM\u001c%bg\"D#\u0001C7\u0002%=t'+\u001e8oKJ$vn[3o\u000bZ,g\u000e\u001e\u000b\u0004s\u0006-\u0001bBA\u0007\u0013\u0001\u0007\u0011qB\u0001\u0011eVtg.\u001a:U_.,g.\u0012<f]R\u00042aMA\t\u0013\r\t\u0019b\u0003\u0002\u0011%Vtg.\u001a:U_.,g.\u0012<f]RD3!CA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u001f\u00051QM^3oiNLA!!\t\u0002\u001c\tI1+\u001e2tGJL'-\u001a\u0015\u0004\u0001\u0005\u0015\u0002\u0003BA\r\u0003OIA!!\u000b\u0002\u001c\tiQI^3oi2K7\u000f^3oKJD3\u0001AA\u0017!\u0011\ty#!\u0010\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\t9$!\u000f\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u000f\u0002\u0007=\u0014x-\u0003\u0003\u0002@\u0005E\"aB*feZL7-\u001a")
public class RunnerTokenServiceImpl
implements RunnerTokenService {
    private final BroadcastService broadcastService;
    public final RunnerTokenRepository com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository;
    private final LoadingCache<String, Option<String>> runnerTokenCache;

    private LoadingCache<String, Option<String>> runnerTokenCache() {
        return this.runnerTokenCache;
    }

    @Timed
    public RunnerToken createOrUpdateRunnerToken(String runnerId) {
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RRA());
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        if (this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.exists(runnerId)) {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.update(runnerId, tokenHash);
            this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenUpdatedEvent(runnerId), true);
        } else {
            this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.create(runnerId, tokenHash);
            this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenCreatedEvent(runnerId), true);
        }
        return new RunnerToken(runnerId, token);
    }

    @Timed
    public void deleteRunnerToken(String runnerId) {
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.delete(runnerId);
        this.broadcastService.broadcast((XLReleaseEvent)new RunnerTokenDeletedEvent(runnerId), true);
    }

    @Timed
    public Option<String> findByToken(String tokenHash) {
        return (Option)this.runnerTokenCache().get((Object)tokenHash);
    }

    @Subscribe
    public void onRunnerTokenEvent(RunnerTokenEvent runnerTokenEvent) {
        this.runnerTokenCache().invalidateAll();
    }

    public RunnerTokenServiceImpl(BroadcastService broadcastService, RunnerTokenRepository runnerTokenRepository) {
        this.broadcastService = broadcastService;
        this.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository = runnerTokenRepository;
        this.runnerTokenCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Option<String>>(this){
            private final /* synthetic */ RunnerTokenServiceImpl $outer;

            public Option<String> load(String tokenHash) {
                return this.$outer.com$xebialabs$xlrelease$runner$impl$RunnerTokenServiceImpl$$runnerTokenRepository.findByToken(tokenHash);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

