package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner
import com.xebialabs.xlrelease.repository.Ids.{CUSTOM_CONFIGURATION_ROOT, SEPARATOR}
import com.xebialabs.xlrelease.runner.api.internal.RunnerRegistrationResource
import com.xebialabs.xlrelease.runner.api.internal.RunnerRegistrationResource.{RegisterRequest, RegisterResponse}
import com.xebialabs.xlrelease.runner.service.RunnerTokenService
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.ConfigurationService
import org.springframework.stereotype.Controller

import scala.jdk.CollectionConverters._

@Controller
class RunnerRegistrationResourceImpl(permissionChecker: PermissionChecker,
                                     runnerTokenService: RunnerTokenService,
                                     configurationService: ConfigurationService)
  extends RunnerRegistrationResource {
  override def register(registerRequest: RegisterRequest): RegisterResponse = {
    // TODO create runner - we should be authenticated using registration token at this point
    //  authenticated with registration token and uses registration token to generate PAT
    permissionChecker.checkIsAllowedToRegisterRunner()
    val itemId = runnerId(registerRequest.uuid)
    val runner = if (configurationService.exists(itemId)) {
      configurationService.read(itemId).asInstanceOf[RemoteJobRunner]
    } else {
      val newRunner = Type.valueOf(classOf[RemoteJobRunner]).getDescriptor.newInstance(itemId).asInstanceOf[RemoteJobRunner]
      newRunner.setTitle(s"runner - ${registerRequest.uuid}")
      newRunner.setCapabilityTags(registerRequest.capabilities.asJava)
      newRunner.setPublicKey(registerRequest.publicKey)
      configurationService.createOrUpdate(newRunner)
      newRunner
    }
    val runnerToken = runnerTokenService.createOrUpdateRunnerToken(runner.getId())
    val encryptedToken = ContextDataHelper.encryptData(runner, runnerToken.token)
    RegisterResponse(runner.getId(), runner.isEnabled(), runner.capacity, runner.encryptJobData, encryptedToken)
  }

  private def runnerId(uuid: String): String = {
    val parentId = CUSTOM_CONFIGURATION_ROOT
    val typePrefix = Type.valueOf(classOf[Configuration]).getName
    val uuidString = uuid.filterNot(_ == '-')
    s"$parentId$SEPARATOR$typePrefix$uuidString"
  }
}
