/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.sharding.ClusterSharding;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardRegion;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.runner.domain.package;
import com.xebialabs.xlrelease.runner.domain.package$;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor$;
import com.xebialabs.xlrelease.runner.impl.RunnerProxyFactory;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Profile(value={"full"})
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011%!\tC\u0003K\u0001\u0011\u00051\n\u0003\u0005Y\u0001!\u0015\r\u0011\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\t\u0007\u0001\"\u0003c\u0011\u0015y\u0007\u0001\"\u0003q\u0005m\u0019E.^:uKJ,GMU;o]\u0016\u0014\bK]8ys\u001a\u000b7\r^8ss*\u0011QBD\u0001\u0005S6\u0004HN\u0003\u0002\u0010!\u00051!/\u001e8oKJT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\u0007\n\u0005\u0005b!A\u0005*v]:,'\u000f\u0015:pqf4\u0015m\u0019;pef\f\u0011\u0002\u001f7s\u0007>tg-[4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\u0002\u0012AB2p]\u001aLw-\u0003\u0002)K\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\rgf\u001cH/Z7I_2$WM\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[A\ta!Y2u_J\u001c\u0018BA\u0018-\u0005E\t5\r^8s'f\u001cH/Z7I_2$WM]\u0001\u0010gB\u0014\u0018N\\4FqR,gn]5p]B\u0011!'O\u0007\u0002g)\u0011A'N\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005Y:\u0014\u0001B1lW\u0006T!\u0001\u000f\t\u0002\u000fM,\b\u000f]8si&\u0011!h\r\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u00061A(\u001b8jiz\"B!\u0010 @\u0001B\u0011q\u0004\u0001\u0005\u0006E\u0011\u0001\ra\t\u0005\u0006S\u0011\u0001\rA\u000b\u0005\u0006a\u0011\u0001\r!M\u0001\fC\u000e$xN]*zgR,W.F\u0001D!\t!\u0005*D\u0001F\u0015\t1u)A\u0003bGR|'OC\u00017\u0013\tIUIA\u0006BGR|'oU=ti\u0016l\u0017\u0001B5oSR$\u0012\u0001\u0014\t\u000335K!A\u0014\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\rA\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0001V\u0003\u0015Q\u0017M^1y\u0013\t9&KA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\fg\"\f'\u000f\u001a*fO&|g.F\u0001[!\t!5,\u0003\u0002]\u000b\nA\u0011i\u0019;peJ+g-\u0001\u0004de\u0016\fG/\u001a\u000b\u00035~CQ\u0001\u0019\u0005A\u00021\u000ba\u0001]1sC6\u001c\u0018aD3yiJ\f7\r^#oi&$\u00180\u00133\u0016\u0003\r\u0004\"\u0001\u001a7\u000f\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017\u0001C:iCJ$\u0017N\\4\u000b\u0005%<\u0015aB2mkN$XM]\u0005\u0003W\u001a\f1b\u00155be\u0012\u0014VmZ5p]&\u0011QN\u001c\u0002\u0010\u000bb$(/Y2u\u000b:$\u0018\u000e^=JI*\u00111NZ\u0001\u000fKb$(/Y2u'\"\f'\u000fZ%e+\u0005\t\bC\u00013s\u0013\t\u0019hN\u0001\bFqR\u0014\u0018m\u0019;TQ\u0006\u0014H-\u00133)\u0005\u0001)\bC\u0001<~\u001b\u00059(B\u0001=z\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003un\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002y\u0006\u0019qN]4\n\u0005y<(!C\"p[B|g.\u001a8uQ\u001d\u0001\u0011\u0011AA\b\u0003#\u0001B!a\u0001\u0002\f5\u0011\u0011Q\u0001\u0006\u0004'\u0006\u001d!bAA\u0005s\u000691m\u001c8uKb$\u0018\u0002BA\u0007\u0003\u000b\u0011q\u0001\u0015:pM&dW-A\u0003wC2,X\r\f\u0002\u0002\u0014\u0005\u0012\u0011QC\u0001\u0005MVdG\u000e")
public class ClusteredRunnerProxyFactory
implements RunnerProxyFactory {
    private ActorRef shardRegion;
    private final XlrConfig xlrConfig;
    private final ActorSystemHolder systemHolder;
    private final SpringExtension springExtension;
    private volatile boolean bitmap$0;

    private ActorSystem actorSystem() {
        return this.systemHolder.actorSystem();
    }

    @PostConstruct
    public void init() {
        this.shardRegion();
    }

    private ActorRef shardRegion$lzycompute() {
        ClusteredRunnerProxyFactory clusteredRunnerProxyFactory = this;
        synchronized (clusteredRunnerProxyFactory) {
            if (!this.bitmap$0) {
                ActorRef shardRegion;
                ClusterSharding sharding = (ClusterSharding)ClusterSharding$.MODULE$.apply(this.actorSystem());
                Config originalConfig = this.actorSystem().settings().config().getConfig("akka.cluster.sharding");
                Config jobRunnerShardingConfig = this.xlrConfig.xl().getConfig("job-runner.akka.cluster.sharding").withFallback((ConfigMergeable)originalConfig);
                ClusterShardingSettings shardingSettings = ClusterShardingSettings$.MODULE$.apply(jobRunnerShardingConfig);
                Props actorProps = this.springExtension.props(RunnerProxyActor.class, (Seq)Nil$.MODULE$);
                this.shardRegion = shardRegion = sharding.start("runner-proxy", actorProps, shardingSettings, this.extractEntityId(), this.extractShardId());
                this.bitmap$0 = true;
            }
        }
        return this.shardRegion;
    }

    public ActorRef shardRegion() {
        return !this.bitmap$0 ? this.shardRegion$lzycompute() : this.shardRegion;
    }

    @Override
    public ActorRef create(BoxedUnit params) {
        return this.shardRegion();
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractEntityId() {
        return new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RunnerProxyActor.RunnerProxyCommand) {
                    RunnerProxyActor.RunnerProxyCommand runnerProxyCommand = (RunnerProxyActor.RunnerProxyCommand)A1;
                    String entityId = RunnerProxyActor$.MODULE$.actorName(runnerProxyCommand.runnerId());
                    object = new Tuple2((Object)entityId, (Object)runnerProxyCommand);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof RunnerProxyActor.RunnerProxyCommand;
                return bl;
            }
        };
    }

    private Function1<Object, String> extractShardId() {
        return (Function1 & Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof RunnerProxyActor.RunnerProxyCommand) {
                RunnerProxyActor.RunnerProxyCommand runnerProxyCommand = (RunnerProxyActor.RunnerProxyCommand)object;
                String entityId = RunnerProxyActor$.MODULE$.actorName(runnerProxyCommand.runnerId());
                string = package.RunnerIdOps$.MODULE$.shardId$extension(package$.MODULE$.RunnerIdOps(entityId));
            } else if (object instanceof ShardRegion.StartEntity) {
                ShardRegion.StartEntity startEntity = (ShardRegion.StartEntity)object;
                String entityId = startEntity.entityId();
                string = package.RunnerIdOps$.MODULE$.shardId$extension(package$.MODULE$.RunnerIdOps(entityId));
            } else {
                throw new MatchError(object);
            }
            return string;
        };
    }

    public ClusteredRunnerProxyFactory(XlrConfig xlrConfig, ActorSystemHolder systemHolder, SpringExtension springExtension) {
        this.xlrConfig = xlrConfig;
        this.systemHolder = systemHolder;
        this.springExtension = springExtension;
    }
}

