package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.runner.api.v1.JobRunnerResource
import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.runner.service.RunnerJobService
import com.xebialabs.xlrelease.scheduler.storage.spring.StorageConfiguration.URI_SCHEME_LOCAL_STORAGE
import com.xebialabs.xlrelease.storage.domain.LogEntry
import com.xebialabs.xlrelease.storage.service.StorageService
import org.springframework.stereotype.Controller

import javax.ws.rs.sse.{Sse, SseEventSink}

@Controller
class JobRunnerResourceImpl(runnerJobService: RunnerJobService,
                            runnerControlService: RunnerControlService,
                            storageService: StorageService)
  extends JobRunnerResource {

  // TODO any of these messages can fail or timeout - handle errors on the client side
  //  i.e. see how we can get and log meaningful data
  //  remember we cannot use debugger and resteasy hides interesting details (like when deserialization fails)

  override def getJob(runnerId: String): JobData = {
    val jobData = runnerJobService.getJob(runnerId)
    jobData
  }

  override def failJob(jobId: JobId): Unit = {
    runnerJobService.failJob(jobId)
  }

  override def finishJob(jobResult: JobResult): Unit = {
    runnerJobService.finishJob(jobResult)
  }

  override def log(logEntry: LogEntry): Unit = {
    // TODO temporary storing entry here, but maybe we should do it inside of the service
    val workerLogEntry = logEntry.copy(uriScheme = URI_SCHEME_LOCAL_STORAGE)
    val storedEntryUri = storageService.store(workerLogEntry)
    runnerJobService.log(logEntry)
  }

  override def executeDirectives(directives: Seq[JobDirective]): Unit = {
    runnerJobService.executeDirectives(directives)
  }

  override def commands(runnerId: RunnerId, sink: SseEventSink, sse: Sse): Unit = {
    runnerControlService.watch(runnerId, sink, sse)
  }

  override def confirmCommand(runnerId: String, commandId: String): Unit = {
    runnerControlService.confirmCommand(runnerId, commandId)
  }
}
