package com.xebialabs.xlrelease.runner.impl

import akka.actor.{Actor, ActorInitializationException, ActorLogging, ActorRef, DeathPactException, OneForOneStrategy, SupervisorStrategy}
import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor._
import com.xebialabs.xlrelease.support.akka.spring.{SpringActor, SpringExtension}

@SpringActor
class RunnerProxyActorSupervisor extends Actor with ActorLogging {
  override def receive: Receive = {
    case cmd: RunnerProxyCommand =>
      log.debug(s"Received $cmd")
      createOrFind(cmd.runnerId) forward cmd
    case msg =>
      log.error(s"Can't process $msg")
  }

  private def createOrFind(runnerId: RunnerId): ActorRef = {
    val childName = actorName(runnerId)
    context.child(childName).getOrElse {
      log.debug(s"Creating runner proxy for $runnerId")
      SpringExtension.childActorOf(classOf[RunnerProxyActor], childName)
    }
  }

  // TODO supervisor strategy...
  override val supervisorStrategy: OneForOneStrategy = OneForOneStrategy() {
    case _: ActorInitializationException => SupervisorStrategy.Stop
    case _: DeathPactException => SupervisorStrategy.Stop
    case _: Exception => SupervisorStrategy.Restart
  }
}
